/*
 * Decompiled with CFR 0.152.
 */
package step.controller;

import ch.exense.commons.app.ArgumentParser;
import ch.exense.commons.app.Configuration;
import ch.exense.viz.persistence.accessors.GenericVizAccessor;
import ch.exense.viz.rest.VizServlet;
import java.io.File;
import java.io.IOException;
import java.util.logging.LogManager;
import javax.servlet.Servlet;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import step.core.Controller;
import step.core.controller.errorhandling.ErrorFilter;
import step.core.deployment.AccessServices;
import step.core.deployment.AdminServices;
import step.core.deployment.ApplicationServices;
import step.core.deployment.ControllerServices;
import step.core.deployment.HttpSessionFactory;
import step.core.deployment.JacksonMapperProvider;
import step.core.deployment.SecurityFilter;
import step.plugins.interactive.InteractiveServices;

public class ControllerServer {
    private Configuration configuration;
    private Controller controller;
    private Server server;
    private ContextHandlerCollection handlers;
    private Integer port;
    private static final Logger logger = LoggerFactory.getLogger(ControllerServer.class);

    public static void main(String[] args) throws Exception {
        ArgumentParser arguments = new ArgumentParser(args);
        String configStr = arguments.getOption("config");
        Configuration configuration = configStr != null ? new Configuration(new File(configStr), arguments.getOptions()) : new Configuration();
        arguments.entrySet().forEach(e -> configuration.putProperty((String)e.getKey(), (String)e.getValue()));
        ControllerServer.setupLogging();
        new ControllerServer(configuration).start();
    }

    protected static void setupLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
    }

    public ControllerServer(Configuration configuration) {
        this.configuration = configuration;
        this.port = configuration.getPropertyAsInteger("port", Integer.valueOf(8080));
    }

    public void start() throws Exception {
        this.server = new Server();
        this.handlers = new ContextHandlerCollection();
        this.initController();
        this.initWebapp();
        this.setupConnectors();
        this.server.setHandler((Handler)this.handlers);
        this.server.start();
    }

    private void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Error while stopping jetty", (Throwable)e);
        }
        finally {
            this.server.destroy();
        }
        if (this.configuration != null) {
            try {
                this.configuration.close();
            }
            catch (IOException e) {
                logger.error("Error while closing configuration", (Throwable)e);
            }
        }
    }

    private void setupConnectors() {
        HttpConfiguration http = new HttpConfiguration();
        http.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        http.setSecureScheme("https");
        ServerConnector connector = new ServerConnector(this.server);
        connector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(http));
        connector.setPort(this.port.intValue());
        if (this.configuration.getPropertyAsBoolean("ui.ssl.enabled", false)) {
            int httpsPort = this.configuration.getPropertyAsInteger("ui.ssl.port", Integer.valueOf(443));
            http.setSecurePort(httpsPort);
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.configuration.getProperty("ui.ssl.keystore.path"));
            sslContextFactory.setKeyStorePassword(this.configuration.getProperty("ui.ssl.keystore.password"));
            sslContextFactory.setKeyManagerPassword(this.configuration.getProperty("ui.ssl.keymanager.password"));
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
            sslConnector.setPort(httpsPort);
            this.server.addConnector((Connector)sslConnector);
        }
        this.server.addConnector((Connector)connector);
    }

    private void initWebapp() throws Exception {
        ResourceHandler bb = new ResourceHandler();
        bb.setResourceBase(Resource.newClassPathResource((String)"webapp").getURI().toString());
        bb.setEtags(true);
        ContextHandler ctx = new ContextHandler("/");
        ctx.setHandler((Handler)bb);
        this.addHandler((Handler)ctx);
    }

    private void initController() throws Exception {
        final ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(new String[]{ControllerServices.class.getPackage().getName()});
        this.controller = new Controller(this.configuration);
        this.controller.init(new Controller.ServiceRegistrationCallback(){

            public void register(Object component) {
                resourceConfig.register(component);
            }

            public void registerService(Class<?> serviceClass) {
                resourceConfig.registerClasses(new Class[]{serviceClass});
            }

            public void registerHandler(Handler handler) {
                ControllerServer.this.addHandler(handler);
            }

            public void stop() {
                try {
                    ControllerServer.this.stop();
                }
                catch (Exception e) {
                    logger.error("Error while trying to stop the controller", (Throwable)e);
                }
            }
        });
        resourceConfig.register(JacksonMapperProvider.class);
        resourceConfig.register(MultiPartFeature.class);
        resourceConfig.registerClasses(new Class[]{ApplicationServices.class});
        resourceConfig.registerClasses(new Class[]{ControllerServices.class});
        resourceConfig.registerClasses(new Class[]{InteractiveServices.class});
        resourceConfig.registerClasses(new Class[]{AccessServices.class});
        resourceConfig.registerClasses(new Class[]{SecurityFilter.class});
        resourceConfig.registerClasses(new Class[]{ErrorFilter.class});
        resourceConfig.registerClasses(new Class[]{AdminServices.class});
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(ControllerServer.this.controller).to(Controller.class);
                this.bindFactory(HttpSessionFactory.class).to(HttpSession.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
            }
        });
        resourceConfig.registerClasses(new Class[]{VizServlet.class});
        final GenericVizAccessor accessor = new GenericVizAccessor(this.controller.getContext().getCollectionFactory());
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(accessor).to(GenericVizAccessor.class);
            }
        });
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/rest");
        context.addServlet(sh, "/*");
        SessionHandler s = new SessionHandler();
        Integer timeout = this.configuration.getPropertyAsInteger("ui.sessiontimeout.minutes", Integer.valueOf(180)) * 60;
        s.setMaxInactiveInterval(timeout.intValue());
        s.setUsingCookies(true);
        s.setSessionCookie("sessionid");
        context.setSessionHandler(s);
        this.addHandler((Handler)context);
    }

    private synchronized void addHandler(Handler handler) {
        this.handlers.addHandler(handler);
    }
}

