/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import step.core.collections.Collection;
import step.core.collections.mongodb.MongoDBCollection;

public class MongoClientSession
implements Closeable {
    protected final MongoClient mongoClient;
    protected final String db;
    protected final Integer batchSize;

    public MongoClientSession(Properties properties) {
        String host = properties.getProperty("host");
        Integer port = this.getIntegerProperty(properties, "port", 27017);
        String user = properties.getProperty("username");
        String pwd = properties.getProperty("password");
        int maxConnections = this.getIntegerProperty(properties, "maxConnections", 200);
        Integer minConnections = this.getIntegerProperty(properties, "minConnections");
        Integer maxConnectionIdleTimeMs = this.getIntegerProperty(properties, "maxConnectionIdleTimeMs");
        Integer maintenanceFrequencyMs = this.getIntegerProperty(properties, "maintenanceFrequencyMs");
        Integer maxConnectionLifeTimeMs = this.getIntegerProperty(properties, "maxConnectionLifeTimeMs");
        Integer maxWaitTimeMs = this.getIntegerProperty(properties, "maxWaitTimeMs");
        this.batchSize = this.getIntegerProperty(properties, "batchSize", 1000);
        this.db = properties.getProperty("database", "step");
        String credentialsDB = properties.getProperty("credentialsDB", this.db);
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        if (user != null) {
            MongoCredential credential = MongoCredential.createCredential((String)user, (String)credentialsDB, (char[])pwd.toCharArray());
            builder.credential(credential);
        }
        builder.applyConnectionString(new ConnectionString("mongodb://" + host + ":" + port));
        builder.applyToConnectionPoolSettings(poolSettingBuilder -> {
            poolSettingBuilder.maxSize(maxConnections);
            if (minConnections != null) {
                poolSettingBuilder.minSize(minConnections.intValue());
            }
            if (maxConnectionIdleTimeMs != null) {
                poolSettingBuilder.maxConnectionIdleTime((long)maxConnectionIdleTimeMs.intValue(), TimeUnit.MILLISECONDS);
            }
            if (maintenanceFrequencyMs != null) {
                poolSettingBuilder.maintenanceFrequency((long)maintenanceFrequencyMs.intValue(), TimeUnit.MILLISECONDS);
            }
            if (maxConnectionLifeTimeMs != null) {
                poolSettingBuilder.maxConnectionLifeTime((long)maxConnectionLifeTimeMs.intValue(), TimeUnit.MILLISECONDS);
            }
            if (maxWaitTimeMs != null) {
                poolSettingBuilder.maxWaitTime((long)maxWaitTimeMs.intValue(), TimeUnit.MILLISECONDS);
            }
            poolSettingBuilder.addConnectionPoolListener((ConnectionPoolListener)new JMXConnectionPoolListener());
            poolSettingBuilder.build();
        });
        this.mongoClient = MongoClients.create((MongoClientSettings)builder.build());
    }

    private Integer getIntegerProperty(Properties properties, String key) {
        return this.getIntegerProperty(properties, key, null);
    }

    private Integer getIntegerProperty(Properties properties, String key, Integer defaultValue) {
        String property = properties.getProperty(key);
        return property != null ? Integer.decode(property) : defaultValue;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoClient.getDatabase(this.db);
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public <T> Collection<T> getEntityCollection(String name, Class<T> entityClass) {
        return new MongoDBCollection<T>(this, name, entityClass);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void close() throws IOException {
        this.mongoClient.close();
    }
}

