/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Projections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mongojack.JacksonMongoCollection;
import org.mongojack.ObjectMapperConfigurer;
import org.mongojack.SerializationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.collections.AbstractCollection;
import step.core.collections.Collection;
import step.core.collections.Document;
import step.core.collections.Filter;
import step.core.collections.SearchOrder;
import step.core.collections.mongodb.MongoClientSession;
import step.core.collections.mongodb.MongoDBCollectionJacksonMapperProvider;
import step.core.collections.mongodb.MongoDBFilterFactory;

public class MongoDBCollection<T>
extends AbstractCollection<T>
implements Collection<T> {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBCollection.class);
    protected static final String CSV_DELIMITER = ";";
    private final MongoClientSession mongoClientSession;
    private final Class<T> entityClass;
    private JacksonMongoCollection<T> collection;

    public MongoDBCollection(MongoClientSession mongoClientSession, String collectionName, Class<T> entityClass) {
        this.mongoClientSession = mongoClientSession;
        this.entityClass = entityClass;
        this.collection = JacksonMongoCollection.builder().withObjectMapper(ObjectMapperConfigurer.configureObjectMapper((ObjectMapper)MongoDBCollectionJacksonMapperProvider.getObjectMapper())).withSerializationOptions(SerializationOptions.builder().withSimpleFilterSerialization(true).build()).build(mongoClientSession.getMongoDatabase(), collectionName, entityClass, UuidRepresentation.JAVA_LEGACY);
    }

    public long count(Filter filter, Integer limit) {
        Bson query = this.filterToQuery(filter);
        CountOptions countOptions = new CountOptions();
        if (limit != null) {
            countOptions.limit(limit.intValue());
        }
        return this.collection.countDocuments(query, countOptions);
    }

    public long estimatedCount() {
        return this.collection.estimatedDocumentCount();
    }

    public List<String> distinct(String columnName, Filter filter) {
        Bson query = this.filterToQuery(filter);
        if (columnName.equals("id")) {
            return (List)this.collection.distinct("_id", query, ObjectId.class).map(ObjectId::toString).into(new ArrayList());
        }
        return (List)this.collection.distinct(columnName, query, String.class).into(new ArrayList());
    }

    private Bson filterToQuery(Filter filter) {
        return new MongoDBFilterFactory().buildFilter(filter);
    }

    public Stream<T> find(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime) {
        return this.find(filter, order, skip, limit, maxTime, null);
    }

    public Stream<T> findLazy(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime) {
        return this.find(filter, order, skip, limit, maxTime);
    }

    public Stream<T> findReduced(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime, List<String> reduceFields) {
        return this.find(filter, order, skip, limit, maxTime, reduceFields);
    }

    private Stream<T> find(Filter filter, SearchOrder order, Integer skip, Integer limit, int maxTime, List<String> reduceFields) {
        MongoCursor iterator;
        FindIterable find;
        Bson query = this.filterToQuery(filter);
        FindIterable findIterable = find = reduceFields != null && !reduceFields.isEmpty() ? this.collection.find(query).projection(Projections.include(reduceFields)).maxTime((long)maxTime, TimeUnit.SECONDS).batchSize(this.mongoClientSession.getBatchSize().intValue()) : this.collection.find(query).maxTime((long)maxTime, TimeUnit.SECONDS).batchSize(this.mongoClientSession.getBatchSize().intValue());
        if (order != null) {
            String attributeName = this.fixAttributeName(order.getAttributeName());
            org.bson.Document sortDoc = new org.bson.Document(attributeName, (Object)order.getOrder());
            find.sort((Bson)sortDoc);
        }
        if (skip != null) {
            find.skip(skip.intValue());
        }
        if (limit != null) {
            find.limit(limit.intValue());
        }
        try {
            iterator = find.iterator();
        }
        catch (MongoExecutionTimeoutException e) {
            logger.error("Query execution exceeded timeout of " + maxTime + " " + TimeUnit.SECONDS);
            throw e;
        }
        Iterator enrichedIterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object next = iterator.next();
                MongoDBCollection.this.fixIdAfterRead(next);
                return next;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(enrichedIterator, 16), false);
    }

    private String fixAttributeName(String attributeName) {
        if (attributeName.equals("id")) {
            attributeName = "_id";
        } else if (attributeName.contains(".id")) {
            attributeName = attributeName.replace(".id", "._id");
        }
        return attributeName;
    }

    private void fixIdAfterRead(T next) {
        if (next instanceof Document) {
            Document document = (Document)next;
            Object id = document.get((Object)"_id");
            if (id instanceof ObjectId) {
                id = id.toString();
            }
            document.put("id", id);
            document.remove((Object)"_id");
        }
    }

    private void fixIdBeforeSave(T next) {
        if (next instanceof Document) {
            Document document = (Document)next;
            Object id = document.get((Object)"id");
            if (id instanceof String) {
                id = new ObjectId((String)id);
            }
            document.put("_id", id);
            document.remove((Object)"id");
        }
    }

    public void remove(Filter filter) {
        this.collection.deleteMany(this.filterToQuery(filter));
    }

    public T save(T entity) {
        if (this.getId(entity) == null) {
            this.setId(entity, new ObjectId());
        }
        this.fixIdBeforeSave(entity);
        this.collection.save(entity);
        this.fixIdAfterRead(entity);
        return entity;
    }

    public void save(Iterable<T> entities) {
        entities.forEach(this::save);
    }

    public void createOrUpdateIndex(String field) {
        this.createOrUpdateIndex(field, 1);
    }

    public void createOrUpdateIndex(String field, int order) {
        MongoDBCollection.createOrUpdateIndex(this.collection, field, order);
    }

    public void createOrUpdateCompoundIndex(String ... fields) {
        LinkedHashMap<String, Integer> fieldsMap = new LinkedHashMap<String, Integer>();
        Arrays.asList(fields).forEach(s -> fieldsMap.put((String)s, 1));
        this.createOrUpdateCompoundIndex(fieldsMap);
    }

    public void createOrUpdateCompoundIndex(Map<String, Integer> fields) {
        MongoDBCollection.createOrUpdateCompoundIndex(this.collection, fields);
    }

    public static void createOrUpdateIndex(MongoCollection<?> collection, String attribute, int order) {
        org.bson.Document index = MongoDBCollection.getIndex(collection, Set.of(attribute));
        if (index == null) {
            collection.createIndex((Bson)new org.bson.Document(attribute, (Object)order));
        }
    }

    public static void createOrUpdateCompoundIndex(MongoCollection<?> collection, Map<String, Integer> fields) {
        org.bson.Document index = MongoDBCollection.getIndex(collection, fields.keySet());
        if (index == null) {
            org.bson.Document newIndex = new org.bson.Document();
            for (String key : fields.keySet()) {
                newIndex.append(key, (Object)fields.get(key));
            }
            collection.createIndex((Bson)newIndex);
        }
    }

    private static org.bson.Document getIndex(MongoCollection<?> collection, Set<String> attributes) {
        for (org.bson.Document index : collection.listIndexes()) {
            org.bson.Document d;
            Object o = index.get((Object)"key");
            if (!(o instanceof org.bson.Document) || !attributes.equals((d = (org.bson.Document)o).keySet())) continue;
            return d;
        }
        return null;
    }

    public void rename(String newName) {
        this.collection.renameCollection(new MongoNamespace(this.mongoClientSession.getMongoDatabase().getName(), newName));
    }

    public void drop() {
        this.collection.drop();
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

