/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.mongodb;

import java.io.IOException;
import java.util.Properties;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;
import step.core.collections.EntityVersion;
import step.core.collections.mongodb.MongoClientSession;

public class MongoDBCollectionFactory
implements CollectionFactory {
    private final MongoClientSession mongoClientSession;

    public MongoDBCollectionFactory(Properties properties) {
        this.mongoClientSession = new MongoClientSession(properties);
    }

    public MongoClientSession getMongoClientSession() {
        return this.mongoClientSession;
    }

    public <T> Collection<T> getCollection(String name, Class<T> entityClass) {
        return this.mongoClientSession.getEntityCollection(name, entityClass);
    }

    public Collection<EntityVersion> getVersionedCollection(String baseName) {
        return this.mongoClientSession.getEntityCollection(baseName + "versions", EntityVersion.class);
    }

    public void close() throws IOException {
        this.mongoClientSession.close();
    }
}

