/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.mongodb;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import step.core.accessors.DefaultJacksonMapperProvider;
import step.core.collections.serialization.DottedKeyMap;
import step.core.collections.serialization.DottedMapKeyDeserializer;
import step.core.collections.serialization.DottedMapKeySerializer;

class MongoDBCollectionJacksonMapperProvider {
    public static List<Module> modules = new ArrayList<Module>();

    MongoDBCollectionJacksonMapperProvider() {
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        modules.forEach(m -> objectMapper.registerModule(m));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    static {
        modules.addAll(DefaultJacksonMapperProvider.getCustomModules());
        modules.add((Module)new DefaultAccessorModule());
    }

    private static class DefaultAccessorModule
    extends SimpleModule {
        private static final long serialVersionUID = 5544301456563146100L;

        public DefaultAccessorModule() {
            this.addSerializer(DottedKeyMap.class, (JsonSerializer)new DottedMapKeySerializer());
            this.addDeserializer(DottedKeyMap.class, (JsonDeserializer)new DottedMapKeyDeserializer());
        }
    }
}

