/*
 * Decompiled with CFR 0.152.
 */
package step.core.collections.mongodb;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import step.core.collections.Filter;
import step.core.collections.Filters;
import step.core.collections.filters.And;
import step.core.collections.filters.Equals;
import step.core.collections.filters.False;
import step.core.collections.filters.Gt;
import step.core.collections.filters.Gte;
import step.core.collections.filters.Lt;
import step.core.collections.filters.Lte;
import step.core.collections.filters.Not;
import step.core.collections.filters.Or;
import step.core.collections.filters.Regex;
import step.core.collections.filters.True;

public class MongoDBFilterFactory
implements Filters.FilterFactory<Bson> {
    public Bson buildFilter(Filter filter) {
        List children = filter.getChildren();
        List childerPojoFilters = children != null ? filter.getChildren().stream().map(this::buildFilter).collect(Collectors.toList()) : null;
        if (filter instanceof And) {
            return Filters.and(childerPojoFilters);
        }
        if (filter instanceof Or) {
            return Filters.or(childerPojoFilters);
        }
        if (filter instanceof Not) {
            return Filters.not((Bson)((Bson)childerPojoFilters.get(0)));
        }
        if (filter instanceof True) {
            return Filters.expr((Object)true);
        }
        if (filter instanceof False) {
            return Filters.expr((Object)false);
        }
        if (filter instanceof Equals) {
            Equals equalsFilter = (Equals)filter;
            String field = equalsFilter.getField();
            Object expectedValue = equalsFilter.getExpectedValue();
            if (field.equals("id")) {
                field = "_id";
                if (expectedValue instanceof String) {
                    expectedValue = new ObjectId((String)expectedValue);
                }
            }
            return Filters.eq((String)field, (Object)expectedValue);
        }
        if (filter instanceof Regex) {
            Regex regexFilter = (Regex)filter;
            if (regexFilter.isCaseSensitive()) {
                return Filters.regex((String)regexFilter.getField(), (String)regexFilter.getExpression());
            }
            return Filters.regex((String)regexFilter.getField(), (String)regexFilter.getExpression(), (String)"i");
        }
        if (filter instanceof Gt) {
            Gt gtFilter = (Gt)filter;
            return Filters.gt((String)gtFilter.getField(), (Object)gtFilter.getValue());
        }
        if (filter instanceof Gte) {
            Gte gteFilter = (Gte)filter;
            return Filters.gte((String)gteFilter.getField(), (Object)gteFilter.getValue());
        }
        if (filter instanceof Lt) {
            Lt ltFilter = (Lt)filter;
            return Filters.lt((String)ltFilter.getField(), (Object)ltFilter.getValue());
        }
        if (filter instanceof Lte) {
            Lte lteFilter = (Lte)filter;
            return Filters.lte((String)lteFilter.getField(), (Object)lteFilter.getValue());
        }
        throw new IllegalArgumentException("Unsupported filter type " + filter.getClass());
    }
}

