/*
 * Decompiled with CFR 0.152.
 */
package step.core.timeseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.timeseries.BucketAttributes;

public class Bucket
extends AbstractIdentifiableObject {
    private long begin;
    private Long end;
    private BucketAttributes attributes;
    private long count;
    private long sum;
    private long min;
    private long max;
    private long pclPrecision;
    private Map<Long, Long> distribution;

    public Bucket() {
    }

    public Bucket(long begin) {
        this.begin = begin;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.begin = begin;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public BucketAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(BucketAttributes attributes) {
        this.attributes = attributes;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSum() {
        return this.sum;
    }

    public void setSum(long sum) {
        this.sum = sum;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public Map<Long, Long> getDistribution() {
        return this.distribution;
    }

    public long getPclPrecision() {
        return this.pclPrecision;
    }

    public void setPclPrecision(long pclPrecision) {
        this.pclPrecision = pclPrecision;
    }

    public void setDistribution(Map<Long, Long> distribution) {
        this.distribution = distribution;
    }

    public long getPercentile(int percentile) {
        long numberOfPointsAtPercentile = (long)(1.0 * (double)percentile / 100.0 * (double)this.count);
        LongAdder count = new LongAdder();
        long percentileValue = 0L;
        ArrayList<Long> keys = new ArrayList<Long>(this.distribution.keySet());
        Collections.sort(keys);
        for (Long key : keys) {
            Long value = this.distribution.get(key);
            count.add(value);
            percentileValue = key;
            if (count.longValue() < numberOfPointsAtPercentile) continue;
            break;
        }
        return percentileValue;
    }
}

