/*
 * Decompiled with CFR 0.152.
 */
package step.core.timeseries;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import step.core.timeseries.Bucket;
import step.core.timeseries.BucketAttributes;

public class BucketBuilder {
    private final long begin;
    private final Long end;
    private BucketAttributes attributes;
    private final LongAdder countAdder = new LongAdder();
    private final LongAdder sumAdder = new LongAdder();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final Map<Long, LongAdder> distribution = new ConcurrentHashMap<Long, LongAdder>();
    private final long pclPrecision = 10L;

    public BucketBuilder(long begin) {
        this.begin = begin;
        this.end = null;
    }

    public BucketBuilder(long begin, long end) {
        this.begin = begin;
        this.end = end;
    }

    public BucketBuilder withAttributes(BucketAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public static BucketBuilder create(long begin) {
        return new BucketBuilder(begin);
    }

    public BucketBuilder ingest(long value) {
        this.countAdder.increment();
        this.sumAdder.add(value);
        this.updateMin(value);
        this.updateMax(value);
        this.distribution.computeIfAbsent(value - value % 10L, k -> new LongAdder()).increment();
        return this;
    }

    public BucketBuilder accumulate(Bucket bucket) {
        this.countAdder.add(bucket.getCount());
        this.sumAdder.add(bucket.getSum());
        this.updateMin(bucket.getMin());
        this.updateMax(bucket.getMax());
        Map<Long, Long> bucketDistribution = bucket.getDistribution();
        if (bucketDistribution != null) {
            bucketDistribution.forEach((key, value) -> this.distribution.computeIfAbsent((Long)key, k -> new LongAdder()).add((long)value));
        }
        return this;
    }

    public long getBegin() {
        return this.begin;
    }

    public Long getEnd() {
        return this.end;
    }

    private void updateMin(long value) {
        this.min.updateAndGet(curMin -> Math.min(value, curMin));
    }

    private void updateMax(long value) {
        this.max.updateAndGet(curMax -> Math.max(value, curMax));
    }

    public Bucket build() {
        Bucket bucket = new Bucket();
        bucket.setBegin(this.begin);
        bucket.setEnd(this.end);
        bucket.setAttributes(this.attributes);
        bucket.setCount(this.countAdder.longValue());
        bucket.setSum(this.sumAdder.longValue());
        bucket.setMin(this.min.longValue());
        bucket.setMax(this.max.longValue());
        bucket.setPclPrecision(10L);
        bucket.setDistribution(this.distribution.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LongAdder)e.getValue()).longValue())));
        return bucket;
    }
}

