/*
 * Decompiled with CFR 0.152.
 */
package step.core.timeseries;

import java.util.Set;
import step.core.collections.Collection;
import step.core.collections.CollectionFactory;
import step.core.timeseries.Bucket;
import step.core.timeseries.TimeSeriesAggregationPipeline;
import step.core.timeseries.TimeSeriesIngestionPipeline;

public class TimeSeries {
    private final Collection<Bucket> collection;
    private final Set<String> indexedFields;
    private final Integer timeSeriesResolution;

    public TimeSeries(Collection<Bucket> collection, Set<String> indexedAttributes, Integer timeSeriesResolution) {
        this.collection = collection;
        this.indexedFields = indexedAttributes;
        this.timeSeriesResolution = timeSeriesResolution;
        this.createIndexes();
    }

    public TimeSeries(CollectionFactory collectionFactory, String collectionName, Set<String> indexedAttributes, Integer ingestionResolutionPeriod) {
        this((Collection<Bucket>)collectionFactory.getCollection(collectionName, Bucket.class), indexedAttributes, ingestionResolutionPeriod);
    }

    private void createIndexes() {
        this.collection.createOrUpdateIndex("begin");
        this.indexedFields.forEach(f -> this.collection.createOrUpdateIndex("attributes." + f));
    }

    public TimeSeriesIngestionPipeline newIngestionPipeline() {
        return new TimeSeriesIngestionPipeline(this.collection, this.timeSeriesResolution.intValue());
    }

    public TimeSeriesIngestionPipeline newIngestionPipeline(long flushingPeriodInMs) {
        return new TimeSeriesIngestionPipeline(this.collection, this.timeSeriesResolution.intValue(), flushingPeriodInMs);
    }

    public TimeSeriesAggregationPipeline getAggregationPipeline() {
        return new TimeSeriesAggregationPipeline(this.collection, this.timeSeriesResolution.intValue());
    }

    protected static long timestampToBucketTimestamp(long timestamp, long resolution) {
        return timestamp - timestamp % resolution;
    }
}

