/*
 * Decompiled with CFR 0.152.
 */
package step.core.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.collections.Collection;
import step.core.collections.Filter;
import step.core.collections.Filters;
import step.core.timeseries.Bucket;
import step.core.timeseries.BucketAttributes;
import step.core.timeseries.BucketBuilder;
import step.core.timeseries.TimeSeriesAggregationQuery;
import step.core.timeseries.TimeSeriesAggregationResponse;

public class TimeSeriesAggregationPipeline {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesAggregationPipeline.class);
    private final long sourceResolution;
    private final Collection<Bucket> collection;

    protected TimeSeriesAggregationPipeline(Collection<Bucket> collectionDriver, long resolution) {
        this.collection = collectionDriver;
        this.sourceResolution = resolution;
    }

    protected long getSourceResolution() {
        return this.sourceResolution;
    }

    private Filter buildFilter(TimeSeriesAggregationQuery query) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (query.getBucketIndexFrom() != null) {
            filters.add(Filters.gte((String)"begin", (long)query.getBucketIndexFrom()));
        }
        if (query.getBucketIndexTo() != null) {
            filters.add(Filters.lt((String)"begin", (long)query.getBucketIndexTo()));
        }
        if (query.getFilters() != null) {
            filters.addAll(query.getFilters().entrySet().stream().map(e -> Filters.equals((String)("attributes." + (String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList()));
        }
        return Filters.and(filters);
    }

    public TimeSeriesAggregationQuery newQuery() {
        return new TimeSeriesAggregationQuery(this);
    }

    protected TimeSeriesAggregationResponse collect(TimeSeriesAggregationQuery query) {
        HashMap seriesBuilder = new HashMap();
        Filter filter = this.buildFilter(query);
        Function<Long, Long> projectionFunction = query.getProjectionFunction();
        LongAdder bucketCount = new LongAdder();
        long t1 = System.currentTimeMillis();
        this.collection.find(filter, null, null, null, 0).forEach(bucket -> {
            bucketCount.increment();
            BucketAttributes bucketAttributes = bucket.getAttributes();
            BucketAttributes seriesKey = CollectionUtils.isNotEmpty(query.getGroupDimensions()) ? bucketAttributes.subset(query.getGroupDimensions()) : new BucketAttributes();
            Map series = seriesBuilder.computeIfAbsent(seriesKey, a -> new TreeMap());
            long index = (Long)projectionFunction.apply(bucket.getBegin());
            series.computeIfAbsent(index, i -> new BucketBuilder((long)i, i + query.getBucketSize())).accumulate((Bucket)((Object)bucket));
        });
        long t2 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.info("Performed query in " + (t2 - t1) + "ms. Number of buckets processed: " + bucketCount.longValue());
        }
        Map<BucketAttributes, Map<Long, Bucket>> result = seriesBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, i -> ((BucketBuilder)i.getValue()).build()))));
        return new TimeSeriesAggregationResponse(result, query.getBucketSize()).withAxis(query.drawAxis());
    }
}

