/*
 * Decompiled with CFR 0.152.
 */
package step.core.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import step.core.timeseries.TimeSeries;
import step.core.timeseries.TimeSeriesAggregationPipeline;
import step.core.timeseries.TimeSeriesAggregationResponse;

public class TimeSeriesAggregationQuery {
    private Long from;
    private Long to;
    private final Map<String, String> filters = new HashMap<String, String>();
    private Set<String> groupDimensions;
    private final long sourceResolution;
    private boolean shrink = false;
    private long resultResolution;
    private Long resultFrom;
    private Long resultTo;
    private final TimeSeriesAggregationPipeline aggregationPipeline;

    protected TimeSeriesAggregationQuery(TimeSeriesAggregationPipeline aggregationPipeline) {
        this.aggregationPipeline = aggregationPipeline;
        this.resultResolution = this.sourceResolution = aggregationPipeline.getSourceResolution();
    }

    public TimeSeriesAggregationQuery range(long from, long to) {
        this.from = from;
        this.to = to;
        return this;
    }

    public TimeSeriesAggregationQuery filter(Map<String, String> filters) {
        this.filters.putAll(filters);
        return this;
    }

    public TimeSeriesAggregationQuery group() {
        this.groupDimensions = Set.of();
        return this;
    }

    public TimeSeriesAggregationQuery groupBy(Set<String> dimensions) {
        this.groupDimensions = dimensions;
        return this;
    }

    public TimeSeriesAggregationQuery window(long resolution) {
        if (resolution < this.sourceResolution) {
            throw new IllegalArgumentException("The resolution cannot be lower than the source resolution of " + this.sourceResolution + "ms");
        }
        this.resultResolution = Math.max(this.sourceResolution, resolution - resolution % this.sourceResolution);
        return this;
    }

    public TimeSeriesAggregationQuery split(long targetNumberOfBuckets) {
        if (targetNumberOfBuckets == 1L) {
            this.shrink = true;
            this.window(Long.MAX_VALUE);
        } else {
            if (this.from == null || this.to == null) {
                throw new IllegalArgumentException("No range specified. The method range() should be called before calling split()");
            }
            long targetResolution = (long)Math.ceil((double)(this.to - this.from) / (double)targetNumberOfBuckets);
            long resolution = targetResolution - targetResolution % this.sourceResolution;
            this.resultResolution = Math.max(this.sourceResolution, resolution);
        }
        return this;
    }

    protected Map<String, String> getFilters() {
        return this.filters;
    }

    protected Set<String> getGroupDimensions() {
        return this.groupDimensions;
    }

    protected Long getBucketIndexFrom() {
        return this.resultFrom;
    }

    protected Long getBucketIndexTo() {
        return this.resultTo;
    }

    protected List<Long> drawAxis() {
        ArrayList<Long> legend = new ArrayList<Long>();
        if (this.from != null && this.to != null) {
            if (this.shrink) {
                legend.add(this.resultFrom);
            } else {
                for (long index = this.resultFrom.longValue(); index < this.resultTo; index += this.resultResolution) {
                    legend.add(index);
                }
            }
        }
        return legend;
    }

    protected Function<Long, Long> getProjectionFunction() {
        if (this.shrink) {
            if (this.resultFrom != null) {
                return t -> this.resultFrom;
            }
            return t -> 0L;
        }
        return t -> TimeSeries.timestampToBucketTimestamp(t, this.resultResolution);
    }

    protected long getBucketSize() {
        if (this.shrink) {
            if (this.resultFrom != null) {
                return this.resultTo - this.resultFrom;
            }
            return Long.MAX_VALUE;
        }
        return this.resultResolution;
    }

    public TimeSeriesAggregationResponse run() {
        if (this.from != null && this.to != null) {
            if (this.shrink) {
                this.resultFrom = this.from - this.from % this.sourceResolution;
                this.resultTo = this.to - this.to % this.sourceResolution + this.sourceResolution;
            } else {
                this.resultFrom = this.from - this.from % this.resultResolution;
                this.resultTo = this.to - (this.to - this.resultFrom) % this.resultResolution + this.resultResolution;
            }
        }
        return this.aggregationPipeline.collect(this);
    }
}

