/*
 * Decompiled with CFR 0.152.
 */
package step.functions.type;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import step.attachments.FileResolver;
import step.core.AbstractStepContext;
import step.core.dynamicbeans.DynamicValue;
import step.functions.Function;
import step.functions.io.Input;
import step.functions.type.FunctionExecutionException;
import step.functions.type.FunctionTypeConfiguration;
import step.functions.type.FunctionTypeException;
import step.functions.type.SetupFunctionException;
import step.grid.GridFileService;
import step.grid.filemanager.FileManagerException;
import step.grid.filemanager.FileVersion;
import step.grid.filemanager.FileVersionId;
import step.grid.tokenpool.Interest;
import step.resources.LayeredResourceManager;
import step.resources.ResourceManager;

public abstract class AbstractFunctionType<T extends Function> {
    protected FileResolver fileResolver;
    protected LoadingCache<String, File> fileResolverCache;
    protected GridFileService gridFileServices;
    protected FunctionTypeConfiguration functionTypeConfiguration;

    protected void setFunctionTypeConfiguration(FunctionTypeConfiguration functionTypeConfiguration) {
        this.functionTypeConfiguration = functionTypeConfiguration;
    }

    protected void setFileResolver(final FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.fileResolverCache = CacheBuilder.newBuilder().concurrencyLevel(this.functionTypeConfiguration.getFileResolverCacheConcurrencyLevel()).maximumSize((long)this.functionTypeConfiguration.getFileResolverCacheMaximumsize()).expireAfterWrite((long)this.functionTypeConfiguration.getFileResolverCacheExpireAfter(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, File>(){

            public File load(String filepath) {
                return fileResolver.resolve(filepath);
            }
        });
    }

    protected void setGridFileServices(GridFileService gridFileServices) {
        this.gridFileServices = gridFileServices;
    }

    protected void init() {
    }

    public Map<String, Interest> getTokenSelectionCriteria(T function) {
        HashMap<String, Interest> criteria = new HashMap<String, Interest>();
        criteria.put("$agenttype", new Interest(Pattern.compile("default"), true));
        return criteria;
    }

    public abstract String getHandlerChain(T var1);

    public FileVersionId getHandlerPackage(T function) {
        return null;
    }

    public abstract Map<String, String> getHandlerProperties(T var1, AbstractStepContext var2);

    public void beforeFunctionCall(T function, Input<?> input, Map<String, String> properties) throws FunctionExecutionException {
    }

    public abstract T newFunction();

    public T newFunction(Map<String, String> configuration) {
        return null;
    }

    public void setupFunction(T function) throws SetupFunctionException {
    }

    public T updateFunction(T function) throws FunctionTypeException {
        return function;
    }

    public T copyFunction(T function) throws FunctionTypeException {
        function.setId(null);
        function.getAttributes().put("name", (String)function.getAttributes().get("name") + "_Copy");
        return function;
    }

    protected void registerFile(DynamicValue<String> dynamicValue, String propertyName, Map<String, String> props, boolean cleanable, AbstractStepContext executionContext) {
        String filepath;
        if (dynamicValue != null && (filepath = (String)dynamicValue.get()) != null && filepath.trim().length() > 0) {
            File file = null;
            try {
                if (executionContext != null) {
                    boolean resolvedFromExecutionContext = false;
                    ResourceManager executionContextResourceManager = this.getResourceManager(executionContext);
                    if (executionContextResourceManager == this.getResourceManager(null)) {
                        file = (File)this.fileResolverCache.get((Object)filepath);
                    } else if (executionContextResourceManager instanceof LayeredResourceManager) {
                        ResourceManager unwrappedManager = this.unwrapResourceManager((LayeredResourceManager)executionContextResourceManager);
                        if (unwrappedManager == this.getResourceManager(null)) {
                            file = (File)this.fileResolverCache.get((Object)filepath);
                        } else {
                            resolvedFromExecutionContext = true;
                            file = (File)executionContext.getFileResolverCache().get((Object)filepath);
                        }
                    } else {
                        resolvedFromExecutionContext = true;
                        file = (File)executionContext.getFileResolverCache().get((Object)filepath);
                    }
                    if (resolvedFromExecutionContext && file == null) {
                        file = (File)this.fileResolverCache.get((Object)filepath);
                    }
                } else {
                    file = (File)this.fileResolverCache.get((Object)filepath);
                }
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Error while resolving path " + filepath, e);
            }
            this.registerFile(file, propertyName, props, cleanable);
        }
    }

    protected void registerFile(File file, String propertyName, Map<String, String> props) {
        this.registerFile(file, propertyName, props, true);
    }

    protected void registerFile(File file, String propertyName, Map<String, String> props, boolean cleanable) {
        FileVersionId fileVersionId = this.registerFile(file, cleanable);
        this.registerFileVersionId(propertyName, props, fileVersionId);
    }

    private ResourceManager unwrapResourceManager(LayeredResourceManager layeredResourceManager) {
        List resourceManagers = layeredResourceManager.getResourceManagers();
        if (resourceManagers.size() != 1) {
            return null;
        }
        if (resourceManagers.get(0) instanceof LayeredResourceManager) {
            return this.unwrapResourceManager((LayeredResourceManager)resourceManagers.get(0));
        }
        return (ResourceManager)resourceManagers.get(0);
    }

    private void registerFileVersionId(String properyName, Map<String, String> props, FileVersionId fileVersionId) {
        props.put(properyName + ".id", fileVersionId.getFileId());
        props.put(properyName + ".version", fileVersionId.getVersion());
    }

    protected FileVersionId registerFile(File file, boolean cleanable) {
        try {
            FileVersion fileVersion = this.gridFileServices.registerFile(file, cleanable);
            return fileVersion.getVersionId();
        }
        catch (FileManagerException e) {
            throw new RuntimeException("Error while registering file " + file.getAbsolutePath(), e);
        }
    }

    protected void registerResource(ClassLoader cl, String resourceName, boolean isDirectory, String propertyName, Map<String, String> props) {
        this.registerResource(cl, resourceName, isDirectory, propertyName, props, true);
    }

    protected void registerResource(ClassLoader cl, String resourceName, boolean isDirectory, String propertyName, Map<String, String> props, boolean cleanable) {
        FileVersionId fileVersionId = this.registerResource(cl, resourceName, isDirectory, cleanable);
        this.registerFileVersionId(propertyName, props, fileVersionId);
    }

    protected FileVersionId registerResource(ClassLoader cl, String resourceName, boolean isDirectory) {
        return this.registerResource(cl, resourceName, isDirectory, false);
    }

    protected FileVersionId registerResource(ClassLoader cl, String resourceName, boolean isDirectory, boolean cleanable) {
        try {
            return this.gridFileServices.registerFile(cl.getResourceAsStream(resourceName), resourceName, isDirectory, cleanable).getVersionId();
        }
        catch (FileManagerException e) {
            throw new RuntimeException("Error while registering resource " + resourceName, e);
        }
    }

    protected FileVersionId registerFile(String filepath, boolean cleanable) {
        return this.registerFile(new File(filepath), cleanable);
    }

    protected ResourceManager getResourceManager(AbstractStepContext executionContext) {
        if (executionContext != null && executionContext.getResourceManager() != null) {
            return executionContext.getResourceManager();
        }
        if (this.fileResolver != null) {
            return this.fileResolver.getResourceManager();
        }
        return null;
    }

    public void deleteFunction(T function) throws FunctionTypeException {
    }
}

