/*
 * Decompiled with CFR 0.152.
 */
package step.functions.execution;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.reports.Error;
import step.core.reports.ErrorType;
import step.functions.Function;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.handler.FunctionInputOutputObjectMapperFactory;
import step.functions.handler.FunctionMessageHandler;
import step.functions.io.FunctionInput;
import step.functions.io.Input;
import step.functions.io.Output;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionExecutionException;
import step.functions.type.FunctionTypeRegistry;
import step.grid.TokenWrapper;
import step.grid.TokenWrapperOwner;
import step.grid.client.AbstractGridClientImpl;
import step.grid.client.GridClient;
import step.grid.client.GridClientException;
import step.grid.filemanager.FileManagerException;
import step.grid.filemanager.FileVersion;
import step.grid.filemanager.FileVersionId;
import step.grid.io.AgentError;
import step.grid.io.AgentErrorCode;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.io.OutputMessage;
import step.grid.tokenpool.Interest;

public class FunctionExecutionServiceImpl
implements FunctionExecutionService {
    private final GridClient gridClient;
    private final FunctionTypeRegistry functionTypeRegistry;
    private final DynamicBeanResolver dynamicBeanResolver;
    private final FileVersionId functionHandlerPackage;
    private final ObjectMapper mapper;
    private static final String KEYWORD_NAME_PROP = "$keywordName";
    private static final String KEYWORD_TIMEOUT_PROP = "$keywordTimeout";
    private static final Logger logger = LoggerFactory.getLogger(FunctionExecutionServiceImpl.class);

    public FunctionExecutionServiceImpl(GridClient gridClient, FunctionTypeRegistry functionTypeRegistry, DynamicBeanResolver dynamicBeanResolver) throws FunctionExecutionServiceException {
        FileVersion functionHandlerPackageVersionId;
        this.gridClient = gridClient;
        this.functionTypeRegistry = functionTypeRegistry;
        this.dynamicBeanResolver = dynamicBeanResolver;
        String functionHandlerResourceName = "step-functions-handler.jar";
        try {
            InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(functionHandlerResourceName);
            functionHandlerPackageVersionId = gridClient.registerFile(resourceAsStream, functionHandlerResourceName, false);
        }
        catch (FileManagerException e) {
            throw new FunctionExecutionServiceException("Error while registering file " + functionHandlerResourceName + " to the grid", (Throwable)e);
        }
        this.functionHandlerPackage = functionHandlerPackageVersionId.getVersionId();
        this.mapper = FunctionInputOutputObjectMapperFactory.createObjectMapper();
    }

    public TokenWrapper getLocalTokenHandle() {
        return this.gridClient.getLocalTokenHandle();
    }

    public TokenWrapper getTokenHandle(Map<String, String> attributes, Map<String, Interest> interests, boolean createSession, TokenWrapperOwner tokenWrapperOwner) throws FunctionExecutionServiceException {
        try {
            return this.gridClient.getTokenHandle(attributes, interests, createSession, tokenWrapperOwner);
        }
        catch (AbstractGridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while reserving the agent token. You can increase the call timeout by setting 'grid.client.token.reserve.timeout.ms' in step.properties", (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexepected error on the agent side while reserving the agent token: " + e.getMessage(), (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while reserving the agent token", (Throwable)e);
        }
    }

    public void returnTokenHandle(String tokenHandleId) throws FunctionExecutionServiceException {
        try {
            this.gridClient.returnTokenHandle(tokenHandleId);
        }
        catch (AbstractGridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while releasing the agent token. You can increase the call timeout by setting 'grid.client.token.release.timeout.ms' in step.properties", (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexepected error on the agent side while releasing the agent token: " + e.getMessage(), (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while releasing the agent token", (Throwable)e);
        }
        catch (GridClientException e) {
            throw new FunctionExecutionServiceException("Unexepected error while releasing the agent token: " + e.getMessage(), (Throwable)e);
        }
    }

    public <IN, OUT> Output<OUT> callFunction(String tokenHandleId, Function function, FunctionInput<IN> functionInput, Class<OUT> outputClass) {
        Input input = new Input();
        input.setPayload(functionInput.getPayload());
        input.setFunction((String)function.getAttributes().get("name"));
        HashMap<String, String> properties = new HashMap<String, String>();
        if (functionInput.getProperties() != null) {
            properties.putAll(functionInput.getProperties());
        }
        Output output = new Output();
        try {
            OutputMessage outputMessage;
            Map handlerProperties;
            AbstractFunctionType functionType = this.functionTypeRegistry.getFunctionTypeByFunction(function);
            this.dynamicBeanResolver.evaluate((Object)function, Collections.unmodifiableMap(properties));
            String handlerChain = functionType.getHandlerChain(function);
            FileVersionId handlerPackage = functionType.getHandlerPackage(function);
            HashMap<String, String> inputMessageProperties = new HashMap<String, String>();
            inputMessageProperties.put("$functionhandler", handlerChain);
            if (handlerPackage != null) {
                inputMessageProperties.putAll(this.fileVersionIdToMap("$functionhandlerjar", handlerPackage));
            }
            if ((handlerProperties = functionType.getHandlerProperties(function)) != null) {
                properties.putAll(handlerProperties);
            }
            functionType.beforeFunctionCall(function, input, properties);
            input.setProperties(properties);
            int callTimeout = (Integer)function.getCallTimeout().get();
            properties.put(KEYWORD_NAME_PROP, input.getFunction());
            properties.put(KEYWORD_TIMEOUT_PROP, Integer.toString(callTimeout));
            if (callTimeout < 100) {
                throw new RuntimeException("The defined call timeout of the function should be higher than 100ms");
            }
            input.setFunctionCallTimeout((long)callTimeout - 100L);
            JsonNode node = this.mapper.valueToTree((Object)input);
            try {
                outputMessage = this.gridClient.call(tokenHandleId, node, FunctionMessageHandler.class.getName(), this.functionHandlerPackage, inputMessageProperties, callTimeout);
            }
            catch (AbstractGridClientImpl.AgentCallTimeoutException e) {
                this.attachUnexpectedExceptionToOutput(output, "Timeout after " + callTimeout + "ms while calling the agent. You can increase the call timeout in the configuration screen of the keyword", (Exception)((Object)e));
                return output;
            }
            catch (AbstractGridClientImpl.AgentSideException e) {
                this.attachUnexpectedExceptionToOutput(output, "Unexpected error on the agent side: " + e.getMessage(), (Exception)((Object)e));
                return output;
            }
            catch (AbstractGridClientImpl.AgentCommunicationException e) {
                this.attachUnexpectedExceptionToOutput(output, "Communication error between the controller and the agent while calling the agent", (Exception)((Object)e));
                return output;
            }
            AgentError agentError = outputMessage.getAgentError();
            if (agentError != null) {
                AgentErrorCode errorCode = agentError.getErrorCode();
                if (errorCode.equals((Object)AgentErrorCode.TIMEOUT_REQUEST_INTERRUPTED)) {
                    output.setError(this.newAgentError("Timeout after " + callTimeout + "ms while executing the keyword on the agent. The keyword execution could be interrupted on the agent side. You can increase the call timeout in the configuration screen of the keyword"));
                } else if (errorCode.equals((Object)AgentErrorCode.TIMEOUT_REQUEST_NOT_INTERRUPTED)) {
                    output.setError(this.newAgentError("Timeout after " + callTimeout + "ms while executing the keyword on the agent. WARNING: The keyword execution couldn't be interrupted on the agent side. You can increase the call timeout in the configuration screen of the keyword"));
                } else if (errorCode.equals((Object)AgentErrorCode.TOKEN_NOT_FOUND)) {
                    output.setError(this.newAgentError("The agent token doesn't exist on the agent side"));
                } else if (errorCode.equals((Object)AgentErrorCode.UNEXPECTED)) {
                    output.setError(this.newAgentError("Unexepected error while executing the keyword on the agent"));
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER)) {
                    output.setError(this.newAgentError("Unexpected error on the agent side while building the execution context of the keyword"));
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_ERROR)) {
                    output.setError(this.newAgentError("Error while downloading a resource from the controller"));
                } else if (errorCode.equals((Object)AgentErrorCode.CONTEXT_BUILDER_FILE_PROVIDER_CALL_TIMEOUT)) {
                    String fileversion;
                    String timeout = (String)agentError.getErrorDetails().get(AgentErrorCode.Details.TIMEOUT);
                    String filehandle = (String)agentError.getErrorDetails().get(AgentErrorCode.Details.FILE_HANDLE);
                    FileVersion fileVersion = this.gridClient.getRegisteredFile(new FileVersionId(filehandle, fileversion = (String)agentError.getErrorDetails().get(AgentErrorCode.Details.FILE_VERSION)));
                    if (fileVersion != null) {
                        output.setError(this.newAgentError("Timeout after " + timeout + "ms while downloading the following resource from the controller: " + fileVersion.getFile().getPath() + ". You can increase the download timeout by setting gridReadTimeout in AgentConf.js"));
                    } else {
                        output.setError(this.newAgentError("Timeout after " + timeout + "ms while downloading a resource from the controller. You can increase the download timeout by setting gridReadTimeout in AgentConf.js"));
                    }
                } else {
                    output.setError(this.newAgentError("Unknown agent error: " + agentError));
                }
            } else {
                JavaType javaType = this.mapper.getTypeFactory().constructParametrizedType(Output.class, Output.class, new Class[]{outputClass});
                output = (Output)this.mapper.readValue(this.mapper.treeAsTokens((TreeNode)outputMessage.getPayload()), javaType);
            }
            if (outputMessage.getAttachments() != null) {
                if (output.getAttachments() == null) {
                    output.setAttachments(outputMessage.getAttachments());
                } else {
                    output.getAttachments().addAll(outputMessage.getAttachments());
                }
            }
            return output;
        }
        catch (FunctionExecutionException e) {
            output.setError(e.getError());
            Exception source = e.getSource();
            if (source != null) {
                this.attachExceptionToOutput(output, source);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.error("Unexpected error while calling function with id " + function.getId().toString(), (Throwable)e);
            }
            this.attachUnexpectedExceptionToOutput(output, e);
        }
        return output;
    }

    private Error newAgentError(String message) {
        return new Error(ErrorType.TECHNICAL, "agent", message, Integer.valueOf(0), true);
    }

    protected Map<String, String> registerFile(File file, String properyName) throws FileManagerException {
        FileVersion fileVersion = this.gridClient.registerFile(file);
        return this.fileVersionIdToMap(properyName, fileVersion.getVersionId());
    }

    protected Map<String, String> fileVersionIdToMap(String propertyName, FileVersionId fileVersionId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(propertyName + ".id", fileVersionId.getFileId());
        props.put(propertyName + ".version", fileVersionId.getVersion());
        return props;
    }

    private void attachUnexpectedExceptionToOutput(Output<?> output, Exception e) {
        this.attachUnexpectedExceptionToOutput(output, "Unexpected error while calling keyword: " + e.getClass().getName() + " " + e.getMessage(), e);
    }

    private void attachUnexpectedExceptionToOutput(Output<?> output, String message, Exception e) {
        output.setError(new Error(ErrorType.TECHNICAL, "functionClient", message, Integer.valueOf(0), true));
        this.attachExceptionToOutput(output, e);
    }

    private void attachExceptionToOutput(Output<?> output, Exception e) {
        Attachment attachment = AttachmentHelper.generateAttachmentForException((Throwable)e);
        ArrayList<Attachment> attachments = output.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            output.setAttachments(attachments);
        }
        attachments.add(attachment);
    }
}

