/*
 * Decompiled with CFR 0.152.
 */
package step.functions.manager;

import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.AbstractIdentifiableObject;
import step.functions.Function;
import step.functions.accessor.FunctionAccessor;
import step.functions.manager.FunctionManager;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeException;
import step.functions.type.FunctionTypeRegistry;
import step.functions.type.SetupFunctionException;

public class FunctionManagerImpl
implements FunctionManager {
    private static final Logger logger = LoggerFactory.getLogger(FunctionManagerImpl.class);
    private final FunctionAccessor functionRepository;
    private final FunctionTypeRegistry functionTypeRegistry;

    public FunctionManagerImpl(FunctionAccessor functionRepository, FunctionTypeRegistry functionTypeRegistry) {
        this.functionRepository = functionRepository;
        this.functionTypeRegistry = functionTypeRegistry;
    }

    public Function saveFunction(Function function) throws SetupFunctionException, FunctionTypeException {
        if (function.getId() == null || this.functionRepository.get(function.getId()) == null) {
            this.setupFunction(function);
        } else {
            this.updateFunction(function);
        }
        return function;
    }

    private void setupFunction(Function function) throws SetupFunctionException {
        AbstractFunctionType<Function> type = this.getFunctionType(function);
        if (type == null) {
            throw new SetupFunctionException("Function type is not resolved for " + function.getClass());
        }
        type.setupFunction(function);
        this.functionRepository.save((AbstractIdentifiableObject)function);
    }

    private Function updateFunction(Function function) throws FunctionTypeException {
        AbstractFunctionType<Function> type = this.getFunctionType(function);
        function = type.updateFunction(function);
        this.functionRepository.save((AbstractIdentifiableObject)function);
        return function;
    }

    public Function copyFunction(String functionId) throws FunctionTypeException {
        Function source = (Function)this.functionRepository.get(new ObjectId(functionId));
        if (source != null) {
            AbstractFunctionType<Function> type = this.getFunctionType(source);
            Function target = type.copyFunction(source);
            this.functionRepository.save((AbstractIdentifiableObject)target);
            return target;
        }
        return null;
    }

    public void deleteFunction(String functionId) throws FunctionTypeException {
        Function function = (Function)this.functionRepository.get(new ObjectId(functionId));
        AbstractFunctionType<Function> type = this.getFunctionType(function);
        type.deleteFunction(function);
        this.functionRepository.remove(function.getId());
    }

    public Function newFunction(String functionType) {
        return this.functionTypeRegistry.getFunctionType(functionType).newFunction();
    }

    public Function newFunction(String functionType, Map<String, String> configuration) {
        return this.functionTypeRegistry.getFunctionType(functionType).newFunction(configuration);
    }

    protected AbstractFunctionType<Function> getFunctionType(Function function) {
        return this.functionTypeRegistry.getFunctionTypeByFunction(function);
    }

    public Function getFunctionByAttributes(Map<String, String> attributes) {
        return (Function)this.functionRepository.findByAttributes(attributes);
    }

    public Function getFunctionById(String id) {
        return (Function)this.functionRepository.get(new ObjectId(id));
    }
}

