/*
 * Decompiled with CFR 0.152.
 */
package step.functions.runner;

import ch.exense.commons.app.Configuration;
import ch.exense.commons.io.FileHelper;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import step.attachments.FileResolver;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.expressions.ExpressionHandler;
import step.functions.Function;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.execution.FunctionExecutionServiceImpl;
import step.functions.io.FunctionInput;
import step.functions.io.Output;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistryImpl;
import step.grid.GridFileService;
import step.grid.client.GridClient;
import step.grid.client.MockedGridClientImpl;
import step.resources.LocalResourceManagerImpl;
import step.resources.ResourceManager;

public class FunctionRunner {
    public static Context getContext(AbstractFunctionType<?> functionType) {
        return new Context(new Configuration(), functionType, new HashMap<String, String>());
    }

    public static Context getContext(AbstractFunctionType<?> functionType, Map<String, String> properties) {
        return new Context(new Configuration(), functionType, properties);
    }

    public static Context getContext(Configuration configuration, AbstractFunctionType<?> functionType, Map<String, String> properties) {
        return new Context(configuration, functionType, properties);
    }

    public static class Context
    implements Closeable {
        Map<String, String> properties;
        FunctionExecutionService functionExecutionService;
        private final GridClient client;
        private final File fileManagerDirectory;

        protected Context(Configuration configuration, AbstractFunctionType<?> functionType, Map<String, String> properties) {
            this.properties = properties;
            try {
                this.fileManagerDirectory = FileHelper.createTempFolder();
            }
            catch (IOException e1) {
                throw new RuntimeException("Error while creating file manager directory", e1);
            }
            this.client = new MockedGridClientImpl();
            FileResolver fileResolver = new FileResolver((ResourceManager)new LocalResourceManagerImpl());
            FunctionTypeRegistryImpl functionTypeRegistry = new FunctionTypeRegistryImpl(fileResolver, (GridFileService)this.client);
            functionTypeRegistry.registerFunctionType(functionType);
            try {
                this.functionExecutionService = new FunctionExecutionServiceImpl(this.client, functionTypeRegistry, new DynamicBeanResolver(new DynamicValueResolver(new ExpressionHandler())));
            }
            catch (FunctionExecutionServiceException e) {
                throw new RuntimeException("Error while creating function execution service", e);
            }
        }

        private JsonObject read(String argument) {
            return Json.createReader((Reader)new StringReader(argument)).readObject();
        }

        public Output<JsonObject> run(Function function, String argument) {
            return this.run(function, this.read(argument));
        }

        public Output<JsonObject> run(Function function, JsonObject argument) {
            FunctionInput input = new FunctionInput();
            input.setPayload((Object)argument);
            input.setProperties(this.properties);
            try {
                return this.functionExecutionService.callFunction(this.functionExecutionService.getLocalTokenHandle().getID(), function, input, JsonObject.class, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.client.close();
            FileHelper.deleteFolder((File)this.fileManagerDirectory);
        }
    }
}

