/*
 * Decompiled with CFR 0.152.
 */
package step.functions.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.AbstractStepContext;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.reports.Error;
import step.core.reports.ErrorType;
import step.functions.Function;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.execution.TokenLifecycleInterceptor;
import step.functions.handler.FunctionIOJakartaObjectMapperFactory;
import step.functions.handler.FunctionIOJavaxObjectMapperFactory;
import step.functions.io.FunctionInput;
import step.functions.io.Output;
import step.functions.type.FunctionTypeRegistry;
import step.grid.TokenWrapper;
import step.grid.TokenWrapperOwner;
import step.grid.client.AbstractGridClientImpl;
import step.grid.client.GridClient;
import step.grid.client.GridClientException;
import step.grid.filemanager.FileManagerException;
import step.grid.filemanager.FileVersion;
import step.grid.filemanager.FileVersionId;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.grid.tokenpool.Interest;

public class FunctionExecutionServiceImpl
implements FunctionExecutionService {
    private final GridClient gridClient;
    private final FunctionTypeRegistry functionTypeRegistry;
    private final DynamicBeanResolver dynamicBeanResolver;
    private final FileVersionId functionHandlerPackage;
    private final ObjectMapper jakartaMapper;
    private final ObjectMapper javaxMapper;
    private static final String KEYWORD_NAME_PROP = "$keywordName";
    private static final String KEYWORD_TIMEOUT_PROP = "$keywordTimeout";
    private static final Logger logger = LoggerFactory.getLogger(FunctionExecutionServiceImpl.class);
    private final List<TokenLifecycleInterceptor> tokenLifecycleInterceptors = new CopyOnWriteArrayList<TokenLifecycleInterceptor>();

    public FunctionExecutionServiceImpl(GridClient gridClient, FunctionTypeRegistry functionTypeRegistry, DynamicBeanResolver dynamicBeanResolver) throws FunctionExecutionServiceException {
        this.gridClient = gridClient;
        this.functionTypeRegistry = functionTypeRegistry;
        this.dynamicBeanResolver = dynamicBeanResolver;
        this.functionHandlerPackage = this.registerClassloaderResource("step-functions-handler.jar");
        this.jakartaMapper = FunctionIOJakartaObjectMapperFactory.createObjectMapper();
        this.javaxMapper = FunctionIOJavaxObjectMapperFactory.createObjectMapper();
    }

    private FileVersionId registerClassloaderResource(String functionHandlerResourceName) throws FunctionExecutionServiceException {
        FileVersion functionHandlerPackageVersionId;
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(functionHandlerResourceName);){
            functionHandlerPackageVersionId = this.gridClient.registerFile(resourceAsStream, functionHandlerResourceName, false, false);
        }
        catch (IOException | FileManagerException e) {
            throw new FunctionExecutionServiceException("Error while registering file " + functionHandlerResourceName + " to the grid", e);
        }
        return functionHandlerPackageVersionId.getVersionId();
    }

    public void registerTokenLifecycleInterceptor(TokenLifecycleInterceptor interceptor) {
        this.tokenLifecycleInterceptors.add(interceptor);
    }

    public void unregisterTokenLifecycleInterceptor(TokenLifecycleInterceptor interceptor) {
        this.tokenLifecycleInterceptors.remove(interceptor);
    }

    public TokenWrapper getLocalTokenHandle() {
        return this.gridClient.getLocalTokenHandle();
    }

    public TokenWrapper getTokenHandle(Map<String, String> attributes, Map<String, Interest> interests, boolean createSession, TokenWrapperOwner tokenWrapperOwner) throws FunctionExecutionServiceException {
        TokenWrapper tokenWrapper = null;
        try {
            tokenWrapper = this.gridClient.getTokenHandle(attributes, interests, createSession, tokenWrapperOwner);
        }
        catch (AbstractGridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while reserving the agent token. You can increase the call timeout by setting 'grid.client.token.reserve.timeout.ms' in step.properties", (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexpected error on the agent side while reserving the agent token: " + e.getMessage(), (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while reserving the agent token", (Throwable)e);
        }
        try {
            for (TokenLifecycleInterceptor interceptor : this.tokenLifecycleInterceptors) {
                interceptor.onGetTokenHandle(tokenWrapper.getID());
            }
        }
        catch (Exception e) {
            try {
                this.returnTokenHandle(tokenWrapper.getID());
            }
            catch (Exception ignored) {
                logger.warn("Unexpected error while returning token handle, ignoring: ", (Throwable)e);
            }
            throw new FunctionExecutionServiceException("Error while retrieving agent token: " + e.getMessage(), (Throwable)e);
        }
        return tokenWrapper;
    }

    public void returnTokenHandle(String tokenHandleId) throws FunctionExecutionServiceException {
        for (TokenLifecycleInterceptor interceptor : this.tokenLifecycleInterceptors) {
            try {
                interceptor.onReturnTokenHandle(tokenHandleId);
            }
            catch (Exception unexpected) {
                logger.error("Unexpected exception in token handle interceptor " + interceptor + ", ignoring", (Throwable)unexpected);
            }
        }
        try {
            this.gridClient.returnTokenHandle(tokenHandleId);
        }
        catch (AbstractGridClientImpl.AgentCallTimeoutException e) {
            throw new FunctionExecutionServiceException("Timeout after " + e.getCallTimeout() + "ms while releasing the agent token. You can increase the call timeout by setting 'grid.client.token.release.timeout.ms' in step.properties", (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentSideException e) {
            throw new FunctionExecutionServiceException("Unexpected error on the agent side while releasing the agent token: " + e.getMessage(), (Throwable)e);
        }
        catch (AbstractGridClientImpl.AgentCommunicationException e) {
            throw new FunctionExecutionServiceException("Communication error between the controller and the agent while releasing the agent token", (Throwable)e);
        }
        catch (GridClientException e) {
            throw new FunctionExecutionServiceException("Unexpected error while releasing the agent token: " + e.getMessage(), (Throwable)e);
        }
    }

    public <IN, OUT> Output<OUT> callFunction(String tokenHandleId, Function function, FunctionInput<IN> functionInput, Class<OUT> outputClass) {
        return this.callFunction(tokenHandleId, function, functionInput, outputClass, null);
    }

    /*
     * Exception decompiling
     */
    public <IN, OUT> Output<OUT> callFunction(String tokenHandleId, Function function, FunctionInput<IN> functionInput, Class<OUT> outputClass, AbstractStepContext executionContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Error newAgentError(String message) {
        return new Error(ErrorType.TECHNICAL, "agent", message, Integer.valueOf(0), true);
    }

    protected Map<String, String> registerFile(File file, String propertyName, boolean cleanable) throws FileManagerException {
        FileVersion fileVersion = this.gridClient.registerFile(file, cleanable);
        return this.fileVersionIdToMap(propertyName, fileVersion.getVersionId());
    }

    protected Map<String, String> fileVersionIdToMap(String propertyName, FileVersionId fileVersionId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(propertyName + ".id", fileVersionId.getFileId());
        props.put(propertyName + ".version", fileVersionId.getVersion());
        return props;
    }

    private void attachUnexpectedExceptionToOutput(Output<?> output, Exception e) {
        this.attachUnexpectedExceptionToOutput(output, "Unexpected error while calling keyword: " + e.getClass().getName() + " " + e.getMessage(), e);
    }

    private void attachUnexpectedExceptionToOutput(Output<?> output, String message, Exception e) {
        output.setError(new Error(ErrorType.TECHNICAL, "functionClient", message, Integer.valueOf(0), true));
        this.attachExceptionToOutput(output, e);
    }

    private void attachExceptionToOutput(Output<?> output, Exception e) {
        Attachment attachment = AttachmentHelper.generateAttachmentForException((Throwable)e);
        ArrayList<Attachment> attachments = output.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            output.setAttachments(attachments);
        }
        attachments.add(attachment);
    }
}

