/*
 * Decompiled with CFR 0.152.
 */
package step.functions.type;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import step.attachments.FileResolver;
import step.functions.Function;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeConfiguration;
import step.functions.type.FunctionTypeRegistry;
import step.grid.GridFileService;

public class FunctionTypeRegistryImpl
implements FunctionTypeRegistry {
    protected final FileResolver fileResolver;
    protected final GridFileService gridFileServices;
    protected final FunctionTypeConfiguration functionTypeConfiguration;
    private final Map<String, AbstractFunctionType<Function>> functionTypes = new ConcurrentHashMap<String, AbstractFunctionType<Function>>();

    public FunctionTypeRegistryImpl(FileResolver fileResolver, GridFileService gridFileServices) {
        this(fileResolver, gridFileServices, new FunctionTypeConfiguration());
    }

    public FunctionTypeRegistryImpl(FileResolver fileResolver, GridFileService gridFileServices, FunctionTypeConfiguration functionTypeConfiguration) {
        this.fileResolver = fileResolver;
        this.gridFileServices = gridFileServices;
        this.functionTypeConfiguration = functionTypeConfiguration;
    }

    public void registerFunctionType(AbstractFunctionType<? extends Function> functionType) {
        functionType.setFunctionTypeConfiguration(this.functionTypeConfiguration);
        functionType.setFileResolver(this.fileResolver);
        functionType.setGridFileServices(this.gridFileServices);
        functionType.init();
        this.functionTypes.put(functionType.newFunction().getClass().getName(), functionType);
    }

    public AbstractFunctionType<Function> getFunctionTypeByFunction(Function function) {
        return this.getFunctionType(function.getClass().getName());
    }

    public AbstractFunctionType<Function> getFunctionType(String functionType) {
        AbstractFunctionType<Function> type = this.functionTypes.get(functionType);
        if (type == null) {
            throw new RuntimeException("Unknown function type '" + functionType + "'");
        }
        return type;
    }
}

