/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr353;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonValueSerializer
extends StdSerializer<JsonValue> {
    public JsonValueSerializer() {
        super(JsonValue.class);
    }

    @Override
    public void serialize(JsonValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        switch (value.getValueType()) {
            case ARRAY: {
                jgen.writeStartArray();
                this.serializeArrayContents((JsonArray)value, jgen, provider);
                jgen.writeEndArray();
                break;
            }
            case OBJECT: {
                jgen.writeStartObject();
                this.serializeObjectContents((JsonObject)value, jgen, provider);
                jgen.writeEndObject();
                break;
            }
            default: {
                this.serializeScalar(value, jgen, provider);
            }
        }
    }

    @Override
    public void serializeWithType(JsonValue value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        switch (value.getValueType()) {
            case ARRAY: {
                jgen.writeStartArray();
                this.serializeArrayContents((JsonArray)value, jgen, provider);
                jgen.writeEndArray();
                break;
            }
            case OBJECT: {
                jgen.writeStartObject();
                this.serializeObjectContents((JsonObject)value, jgen, provider);
                jgen.writeEndObject();
                break;
            }
            default: {
                this.serializeScalar(value, jgen, provider);
            }
        }
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    protected void serializeScalar(JsonValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        switch (value.getValueType()) {
            case FALSE: {
                jgen.writeBoolean(false);
                break;
            }
            case NULL: {
                jgen.writeNull();
                break;
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    jgen.writeNumber(num.longValue());
                    break;
                }
                jgen.writeNumber(num.bigDecimalValue());
                break;
            }
            case STRING: {
                jgen.writeString(((JsonString)value).getString());
                break;
            }
            case TRUE: {
                jgen.writeBoolean(true);
                break;
            }
        }
    }

    protected void serializeArrayContents(JsonArray values, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!values.isEmpty()) {
            for (JsonValue value : values) {
                this.serialize(value, jgen, provider);
            }
        }
    }

    protected void serializeObjectContents(JsonObject ob, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!ob.isEmpty()) {
            for (Map.Entry entry : ob.entrySet()) {
                jgen.writeFieldName((String)entry.getKey());
                this.serialize((JsonValue)entry.getValue(), jgen, provider);
            }
        }
    }
}

