/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import step.core.dynamicbeans.EvaluationResult;

public class DynamicValue<T> {
    boolean dynamic;
    T value;
    @JsonIgnore
    EvaluationResult evalutationResult;
    String expression;
    String expressionType;

    public DynamicValue() {
    }

    public DynamicValue(T value) {
        this.value = value;
        this.dynamic = false;
    }

    public DynamicValue(String expression, String expressionType) {
        this.dynamic = true;
        this.expression = expression;
        this.expressionType = expressionType;
    }

    public T get() {
        if (!this.isDynamic()) {
            return this.value;
        }
        if (this.evalutationResult != null) {
            if (this.evalutationResult.evaluationException != null) {
                throw new RuntimeException("Error while evaluating expression '" + this.expression + "'", this.evalutationResult.evaluationException);
            }
            Object result = this.evalutationResult.getResultValue();
            return (T)result;
        }
        throw new RuntimeException("Expression hasn't been evaluated.");
    }

    public DynamicValue<T> cloneValue() {
        DynamicValue<T> clone = new DynamicValue<T>();
        clone.dynamic = this.dynamic;
        clone.evalutationResult = null;
        clone.expression = this.expression;
        clone.expressionType = this.expressionType;
        clone.value = this.value;
        return clone;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    public String toString() {
        return this.get().toString();
    }
}

