/*
 * Decompiled with CFR 0.152.
 */
package step.functions.io;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.spi.JsonProvider;
import step.core.reports.Error;
import step.core.reports.ErrorType;
import step.core.reports.Measure;
import step.core.reports.MeasurementsBuilder;
import step.functions.io.Output;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;

public class OutputBuilder {
    private JsonObjectBuilder payloadBuilder = jprov.createObjectBuilder();
    private String payloadJson;
    private MeasurementsBuilder measureHelper = new MeasurementsBuilder();
    private Error error;
    private List<Attachment> attachments;
    private static JsonProvider jprov = JsonProvider.provider();
    private Measure lastMeasureHandle = null;

    public JsonObjectBuilder getPayloadBuilder() {
        return this.payloadBuilder;
    }

    public void setPayloadBuilder(JsonObjectBuilder payloadBuilder) {
        this.payloadBuilder = payloadBuilder;
    }

    public OutputBuilder add(String name, boolean value) {
        this.payloadBuilder.add(name, value);
        return this;
    }

    public OutputBuilder add(String name, double value) {
        this.payloadBuilder.add(name, value);
        return this;
    }

    public OutputBuilder add(String name, int value) {
        this.payloadBuilder.add(name, value);
        return this;
    }

    public OutputBuilder add(String name, long value) {
        this.payloadBuilder.add(name, value);
        return this;
    }

    public OutputBuilder add(String name, String value) {
        this.payloadBuilder.add(name, value);
        return this;
    }

    public OutputBuilder setError(String technicalError) {
        this.error = new Error(ErrorType.TECHNICAL, "keyword", technicalError, 0, true);
        return this;
    }

    public OutputBuilder appendError(String technicalError) {
        if (this.error != null) {
            this.error.setMsg(this.error.getMsg() + technicalError);
        } else {
            this.setError(technicalError);
        }
        return this;
    }

    public OutputBuilder setError(String errorMessage, Throwable e) {
        this.setError(errorMessage);
        this.addAttachment(this.generateAttachmentForException(e));
        return this;
    }

    public OutputBuilder setBusinessError(String businessError) {
        this.error = new Error(ErrorType.BUSINESS, "keyword", businessError, 0, true);
        return this;
    }

    public OutputBuilder setError(Error error) {
        this.error = error;
        return this;
    }

    public String getPayloadJson() {
        return this.payloadJson;
    }

    public void setPayloadJson(String payloadJson) {
        this.payloadJson = payloadJson;
    }

    public void addAttachments(List<Attachment> attachments) {
        this.createAttachmentListIfNeeded();
        attachments.addAll(attachments);
    }

    public void addAttachment(Attachment attachment) {
        this.createAttachmentListIfNeeded();
        this.attachments.add(attachment);
    }

    private void createAttachmentListIfNeeded() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
    }

    public void startMeasure(String id) {
        this.measureHelper.startMeasure(id);
    }

    public void startMeasure(String id, long begin) {
        this.measureHelper.startMeasure(id, begin);
    }

    public void addMeasure(String measureName, long durationMillis) {
        this.measureHelper.addMeasure(measureName, durationMillis);
    }

    public void addMeasure(String measureName, long aDurationMillis, Map<String, Object> data) {
        this.measureHelper.addMeasure(measureName, aDurationMillis, data);
    }

    public void stopMeasure() {
        this.measureHelper.stopMeasure();
    }

    public void stopMeasure(Map<String, Object> data) {
        this.measureHelper.stopMeasure(data);
    }

    public void stopMeasureForAdditionalData() {
        this.lastMeasureHandle = this.measureHelper.stopMeasure();
    }

    public void setLastMeasureAdditionalData(Map<String, Object> data) {
        this.lastMeasureHandle.setData(data);
        this.lastMeasureHandle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output<JsonObject> build() {
        JsonObject payload;
        Output<JsonObject> message = new Output<JsonObject>();
        if (this.payloadJson == null) {
            payload = this.payloadBuilder.build();
        } else {
            try (JsonReader reader = Json.createReader(new StringReader(this.payloadJson));){
                payload = reader.readObject();
            }
        }
        message.setPayload(payload);
        message.setMeasures(this.measureHelper.getMeasures());
        message.setAttachments(this.attachments);
        message.setError(this.error);
        return message;
    }

    private Attachment generateAttachmentForException(Throwable e) {
        Attachment attachment = new Attachment();
        attachment.setName("exception.log");
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        attachment.setHexContent(AttachmentHelper.getHex((byte[])w.toString().getBytes()));
        return attachment;
    }
}

