/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr353;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonValueDeserializer
extends StdDeserializer<JsonValue> {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;

    public JsonValueDeserializer(JsonBuilderFactory bf) {
        super(JsonValue.class);
        this._builderFactory = bf;
    }

    @Override
    public JsonValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                return this._deserializeObject(jp, ctxt);
            }
            case START_ARRAY: {
                return this._deserializeArray(jp, ctxt);
            }
        }
        return this._deserializeScalar(jp, ctxt);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeser) throws IOException, JsonProcessingException {
        return typeDeser.deserializeTypedFromScalar(jp, ctxt);
    }

    protected JsonValue _deserializeObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonObjectBuilder b = this._builderFactory.createObjectBuilder();
        block15: while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            JsonToken t = jp.nextToken();
            switch (t) {
                case START_ARRAY: {
                    b.add(name, this._deserializeArray(jp, ctxt));
                    continue block15;
                }
                case START_OBJECT: {
                    b.add(name, this._deserializeObject(jp, ctxt));
                    continue block15;
                }
                case VALUE_FALSE: {
                    b.add(name, false);
                    continue block15;
                }
                case VALUE_TRUE: {
                    b.add(name, true);
                    continue block15;
                }
                case VALUE_NULL: {
                    b.addNull(name);
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(name, jp.getDecimalValue());
                        continue block15;
                    }
                    b.add(name, jp.getDoubleValue());
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    switch (jp.getNumberType()) {
                        case LONG: {
                            b.add(name, jp.getLongValue());
                            continue block15;
                        }
                        case INT: {
                            b.add(name, jp.getIntValue());
                            continue block15;
                        }
                    }
                    b.add(name, jp.getBigIntegerValue());
                    continue block15;
                }
                case VALUE_STRING: {
                    b.add(name, jp.getText());
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object ob = jp.getEmbeddedObject();
                    if (!(ob instanceof byte[])) break;
                    String b64 = ctxt.getBase64Variant().encode((byte[])ob, false);
                    b.add(name, b64);
                    continue block15;
                }
            }
            throw ctxt.mappingException(JsonValue.class);
        }
        return b.build();
    }

    protected JsonValue _deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
        block14: while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    b.add(this._deserializeArray(jp, ctxt));
                    continue block14;
                }
                case START_OBJECT: {
                    b.add(this._deserializeObject(jp, ctxt));
                    continue block14;
                }
                case VALUE_FALSE: {
                    b.add(false);
                    continue block14;
                }
                case VALUE_TRUE: {
                    b.add(true);
                    continue block14;
                }
                case VALUE_NULL: {
                    b.addNull();
                    continue block14;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(jp.getDecimalValue());
                        continue block14;
                    }
                    b.add(jp.getDoubleValue());
                    continue block14;
                }
                case VALUE_NUMBER_INT: {
                    switch (jp.getNumberType()) {
                        case LONG: {
                            b.add(jp.getLongValue());
                            continue block14;
                        }
                        case INT: {
                            b.add(jp.getIntValue());
                            continue block14;
                        }
                    }
                    b.add(jp.getBigIntegerValue());
                    continue block14;
                }
                case VALUE_STRING: {
                    b.add(jp.getText());
                    continue block14;
                }
            }
            throw ctxt.mappingException(JsonValue.class);
        }
        return b.build();
    }

    protected JsonValue _deserializeScalar(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                throw ctxt.mappingException(JsonValue.class);
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER_FLOAT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                if (jp.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return (JsonValue)b.add(jp.getDecimalValue()).build().get(0);
                }
                return (JsonValue)b.add(jp.getDoubleValue()).build().get(0);
            }
            case VALUE_NUMBER_INT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                switch (jp.getNumberType()) {
                    case LONG: {
                        return (JsonValue)b.add(jp.getLongValue()).build().get(0);
                    }
                    case INT: {
                        return (JsonValue)b.add(jp.getIntValue()).build().get(0);
                    }
                }
                return (JsonValue)b.add(jp.getBigIntegerValue()).build().get(0);
            }
            case VALUE_STRING: {
                return (JsonValue)this._builderFactory.createArrayBuilder().add(jp.getText()).build().get(0);
            }
        }
        throw ctxt.mappingException(JsonValue.class);
    }
}

