/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.commons.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileHelper {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static File createTempFile() throws IOException {
        File file = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        file.deleteOnExit();
        return file;
    }

    public static File createTempFolder() throws IOException {
        File file = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        return file;
    }

    public static File createTempFolder(String prefix) throws IOException {
        File file = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        return file;
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileHelper.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static void deleteFolderOnExit(File folder) {
        folder.deleteOnExit();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileHelper.deleteFolderOnExit(f);
                    continue;
                }
                f.deleteOnExit();
            }
        }
    }

    public static final long getLastModificationDateRecursive(File file) {
        return FileHelper.computeLastModification(file);
    }

    protected static final long computeLastModification(File file) {
        return FileHelper.computeLastModificationDateRecursive(file);
    }

    protected static final long computeLastModificationDateRecursive(File file) {
        if (file.isDirectory()) {
            long lastModificationDate = file.lastModified();
            for (File f : file.listFiles()) {
                long lastChange = FileHelper.computeLastModificationDateRecursive(f);
                if (lastChange <= lastModificationDate) continue;
                lastModificationDate = lastChange;
            }
            return lastModificationDate;
        }
        return file.lastModified();
    }

    public static void unzip(File zipFile, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(zipFile);){
            FileHelper.unzip((InputStream)in, target);
        }
    }

    public static void unzip(byte[] bytes, File target) throws IOException {
        FileHelper.unzip((InputStream)new ByteArrayInputStream(bytes), target);
    }

    public static void unzip(InputStream stream, File target) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry entry;
            target.mkdir();
            while ((entry = zip.getNextEntry()) != null) {
                int currentByte;
                String currentEntry = entry.getName().replaceAll("\\\\", "/");
                File destFile = new File(target.getAbsolutePath(), currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = zip.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
            }
        }
    }

    public static File unzip(InputStream stream, String entryName) throws IOException {
        File f = null;
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                int currentByte;
                if (entry.isDirectory() || !entry.getName().equals(entryName)) continue;
                f = FileHelper.createTempFile();
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(f);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = zip.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
            }
        }
        return f;
    }

    public static final void zip(File directory, File target) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(target);
        FileHelper.zip(directory, fileOutputStream);
        fileOutputStream.close();
    }

    public static final void zip(File directory, OutputStream out) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        zos.setLevel(0);
        FileHelper.zip(directory, directory, zos);
        zos.close();
    }

    public static final byte[] zip(File directory) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileHelper.zip(directory, out);
        return out.toByteArray();
    }

    private static final void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                FileHelper.zip(files[i], base, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1).replaceAll("\\\\", "/"));
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static void zipFile(ZipOutputStream zos, ByteArrayOutputStream jsonStream, String name) throws IOException {
        ZipEntry entryJson = new ZipEntry(name.replaceAll("\\\\", "/"));
        zos.putNextEntry(entryJson);
        zos.write(jsonStream.toByteArray());
    }

    public static void zipFile(ZipOutputStream zos, File file, String basePath) throws IOException {
        try {
            byte[] buffer = new byte[8192];
            int read = 0;
            FileInputStream in = new FileInputStream(file);
            ZipEntry entry = new ZipEntry(file.getPath().substring(basePath.length() + 1).replaceAll("\\\\", "/"));
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create archive", e);
        }
    }

    public static boolean isArchive(File f) {
        int fileSignature = 0;
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            fileSignature = raf.readInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileSignature == 1347093252 || fileSignature == 1347093766 || fileSignature == 1347094280;
    }

    public static String readStream(InputStream is) {
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next().replaceAll("\r\n", "\n");
            return string;
        }
    }

    public static String readResource(Class<?> clazz, String resourceName) {
        return FileHelper.readStream(clazz.getResourceAsStream(resourceName));
    }

    public static String readClassLoaderResource(ClassLoader classLoader, String resourceName) {
        return FileHelper.readStream(classLoader.getResourceAsStream(resourceName));
    }

    public static byte[] readResourceAsByteArray(Class<?> clazz, String resourceName) throws IOException {
        try (InputStream resourceAsStream = clazz.getResourceAsStream(resourceName);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                FileHelper.copy(resourceAsStream, out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] readClassLoaderResourceAsByteArray(ClassLoader classLoader, String resourceName) throws IOException {
        try (InputStream resourceAsStream = classLoader.getResourceAsStream(resourceName);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                FileHelper.copy(resourceAsStream, out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static File getClassLoaderResourceAsFile(ClassLoader classLoader, String resourceName) {
        try {
            URL url = classLoader.getResource(resourceName);
            return url != null ? new File(url.toURI().getPath()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error while parsing URI of resource " + resourceName, e);
        }
    }

    public static File extractResourceToTempFile(Class<?> clazz, String resourceName) throws IOException {
        Path tempFile = Files.createTempFile("resourceName", ".tmp", new FileAttribute[0]);
        Files.write(tempFile, FileHelper.readResource(clazz, resourceName).getBytes(), StandardOpenOption.APPEND);
        tempFile.toFile().deleteOnExit();
        return tempFile.toFile();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        FileHelper.copy(input, output, 2048);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
    }
}

