/*
 * Decompiled with CFR 0.152.
 */
package step.functions.handler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import step.functions.handler.FunctionHandlerFactory;
import step.functions.io.Input;
import step.functions.io.Output;
import step.grid.agent.tokenpool.TokenReservationSession;
import step.grid.agent.tokenpool.TokenSession;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.contextbuilder.ApplicationContextBuilderException;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.contextbuilder.LocalFolderApplicationContextFactory;
import step.grid.contextbuilder.LocalResourceApplicationContextFactory;
import step.grid.contextbuilder.RemoteApplicationContextFactory;
import step.grid.filemanager.FileManagerClient;
import step.grid.filemanager.FileManagerException;
import step.grid.filemanager.FileVersion;
import step.grid.filemanager.FileVersionId;

public abstract class AbstractFunctionHandler<IN, OUT> {
    private FileManagerClient fileManagerClient;
    private ApplicationContextBuilder applicationContextBuilder;
    private FunctionHandlerFactory functionHandlerFactory;
    private TokenSession tokenSession;
    private TokenReservationSession tokenReservationSession;
    private Map<String, String> properties;
    public static final String FORKED_BRANCH = "forkedBranch";
    public static final String STEP_NODE_KEY = "currentStep";
    public static final String PARENTREPORTID_KEY = "$parentreportid";
    public static final String EXECUTION_CONTEXT_KEY = "$executionContext";

    protected FunctionHandlerFactory getFunctionHandlerFactory() {
        return this.functionHandlerFactory;
    }

    protected void setFunctionHandlerFactory(FunctionHandlerFactory functionHandlerFactory) {
        this.functionHandlerFactory = functionHandlerFactory;
    }

    protected void setApplicationContextBuilder(ApplicationContextBuilder applicationContextBuilder) {
        this.applicationContextBuilder = applicationContextBuilder;
    }

    protected void setFileManagerClient(FileManagerClient fileManagerClient) {
        this.fileManagerClient = fileManagerClient;
    }

    protected void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    protected Map<String, String> getProperties() {
        return this.properties;
    }

    protected TokenSession getTokenSession() {
        return this.tokenSession;
    }

    protected void setTokenSession(TokenSession tokenSession) {
        this.tokenSession = tokenSession;
    }

    protected TokenReservationSession getTokenReservationSession() {
        return this.tokenReservationSession;
    }

    protected void setTokenReservationSession(TokenReservationSession tokenReservationSession) {
        this.tokenReservationSession = tokenReservationSession;
    }

    public void initialize() {
    }

    protected ApplicationContextBuilder.ApplicationContext getCurrentContext() {
        return this.getCurrentContext("master");
    }

    protected ApplicationContextBuilder.ApplicationContext getCurrentContext(String branch) {
        return this.applicationContextBuilder.getCurrentContext(branch);
    }

    protected <T> T runInContext(Callable<T> callable) throws Exception {
        return (T)this.applicationContextBuilder.runInContext(callable);
    }

    protected <T> T runInContext(String branch, Callable<T> callable) throws Exception {
        return (T)this.applicationContextBuilder.runInContext(branch, callable);
    }

    protected void pushLocalApplicationContext(ClassLoader classLoader, String resourceName) throws ApplicationContextBuilderException {
        this.pushLocalApplicationContext("master", classLoader, resourceName);
    }

    protected void pushLocalApplicationContext(String branch, ClassLoader classLoader, String resourceName) throws ApplicationContextBuilderException {
        LocalResourceApplicationContextFactory localContext = new LocalResourceApplicationContextFactory(classLoader, resourceName);
        this.applicationContextBuilder.pushContext(branch, (ApplicationContextFactory)localContext);
    }

    protected void pushLocalFolderApplicationContext(File libFolder) throws ApplicationContextBuilderException {
        LocalFolderApplicationContextFactory localContext = new LocalFolderApplicationContextFactory(libFolder);
        this.applicationContextBuilder.pushContext("master", (ApplicationContextFactory)localContext);
    }

    protected void pushLocalFolderApplicationContext(String branch, File libFolder) throws ApplicationContextBuilderException {
        LocalFolderApplicationContextFactory localContext = new LocalFolderApplicationContextFactory(libFolder);
        this.applicationContextBuilder.pushContext(branch, (ApplicationContextFactory)localContext);
    }

    protected void pushRemoteApplicationContext(String fileId, Map<String, String> properties) throws ApplicationContextBuilderException {
        this.pushRemoteApplicationContext("master", fileId, properties);
    }

    protected void pushRemoteApplicationContext(String branch, String fileId, Map<String, String> properties) throws ApplicationContextBuilderException {
        FileVersionId librariesFileVersion = this.getFileVersionId(fileId, properties);
        if (librariesFileVersion != null) {
            RemoteApplicationContextFactory librariesContext = new RemoteApplicationContextFactory(this.fileManagerClient, librariesFileVersion);
            this.applicationContextBuilder.pushContext(branch, (ApplicationContextFactory)librariesContext);
        }
    }

    protected Output<OUT> delegate(String branchName, String functionHandlerClassname, Input<IN> input) throws Exception {
        return (Output)this.applicationContextBuilder.runInContext(branchName, () -> {
            AbstractFunctionHandler functionHandler = this.functionHandlerFactory.create(this.applicationContextBuilder.getCurrentContext(branchName).getClassLoader(), functionHandlerClassname, this.tokenSession, this.tokenReservationSession, this.properties);
            return functionHandler.handle(input);
        });
    }

    protected Output<OUT> delegate(String functionHandlerClassname, Input<IN> input) throws Exception {
        return this.delegate("master", functionHandlerClassname, input);
    }

    protected File retrieveFileVersion(String properyName, Map<String, String> properties) throws FileManagerException {
        FileVersionId fileVersionId = this.getFileVersionId(properyName, properties);
        if (fileVersionId != null) {
            FileVersion fileVersion = this.fileManagerClient.requestFileVersion(fileVersionId);
            return fileVersion != null ? fileVersion.getFile() : null;
        }
        return null;
    }

    protected FileVersionId getFileVersionId(String properyName, Map<String, String> properties) {
        String key = properyName + ".id";
        if (properties.containsKey(key)) {
            String transferFileId = properties.get(key);
            String transferFileVersion = properties.get(properyName + ".version");
            return new FileVersionId(transferFileId, transferFileVersion);
        }
        return null;
    }

    protected abstract Output<OUT> handle(Input<IN> var1) throws Exception;

    protected Map<String, String> mergeAllProperties(Input<?> input) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (input.getProperties() != null) {
            properties.putAll(input.getProperties());
        }
        if (this.properties != null) {
            properties.putAll(this.properties);
        }
        return properties;
    }

    public abstract Class<IN> getInputPayloadClass();

    public abstract Class<OUT> getOutputPayloadClass();
}

