/*
 * Decompiled with CFR 0.152.
 */
package step.functions.handler;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import step.core.reports.Measure;
import step.core.reports.MeasurementsBuilder;
import step.functions.handler.AbstractFunctionHandler;
import step.functions.handler.FunctionHandlerFactory;
import step.functions.handler.FunctionInputOutputObjectMapperFactory;
import step.functions.io.Input;
import step.functions.io.Output;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.context.OutputMessageBuilder;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.contextbuilder.ApplicationContextFactory;
import step.grid.contextbuilder.RemoteApplicationContextFactory;
import step.grid.filemanager.FileVersionId;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;

public class FunctionMessageHandler
extends AbstractMessageHandler {
    public static final String FUNCTION_HANDLER_PACKAGE_KEY = "$functionhandlerjar";
    public static final String FUNCTION_HANDLER_KEY = "$functionhandler";
    private ObjectMapper mapper = FunctionInputOutputObjectMapperFactory.createObjectMapper();
    private ApplicationContextBuilder applicationContextBuilder;
    public FunctionHandlerFactory functionHandlerFactory;

    public void init(AgentTokenServices agentTokenServices) {
        super.init(agentTokenServices);
        this.applicationContextBuilder = new ApplicationContextBuilder(((Object)((Object)this)).getClass().getClassLoader());
        this.applicationContextBuilder.forkCurrentContext("forkedBranch");
        this.functionHandlerFactory = new FunctionHandlerFactory(this.applicationContextBuilder, agentTokenServices.getFileManagerClient());
    }

    public OutputMessage handle(AgentTokenWrapper token, InputMessage inputMessage) throws Exception {
        this.applicationContextBuilder.resetContext();
        FileVersionId functionPackage = this.getFileVersionId(FUNCTION_HANDLER_PACKAGE_KEY, inputMessage.getProperties());
        if (functionPackage != null) {
            RemoteApplicationContextFactory functionHandlerContext = new RemoteApplicationContextFactory(token.getServices().getFileManagerClient(), this.getFileVersionId(FUNCTION_HANDLER_PACKAGE_KEY, inputMessage.getProperties()));
            this.applicationContextBuilder.pushContext((ApplicationContextFactory)functionHandlerContext);
        }
        return (OutputMessage)this.applicationContextBuilder.runInContext(() -> {
            Map<String, String> mergedAgentProperties = this.getMergedAgentProperties(token);
            String handlerClass = (String)inputMessage.getProperties().get(FUNCTION_HANDLER_KEY);
            AbstractFunctionHandler functionHandler = this.functionHandlerFactory.create(this.applicationContextBuilder.getCurrentContext().getClassLoader(), handlerClass, token.getSession(), token.getTokenReservationSession(), mergedAgentProperties);
            JavaType javaType = this.mapper.getTypeFactory().constructParametrizedType(Input.class, Input.class, new Class[]{functionHandler.getInputPayloadClass()});
            Input input = (Input)this.mapper.readValue(this.mapper.treeAsTokens((TreeNode)inputMessage.getPayload()), javaType);
            MeasurementsBuilder measurementsBuilder = new MeasurementsBuilder();
            measurementsBuilder.startMeasure(input.getFunction());
            Output output = functionHandler.handle(input);
            measurementsBuilder.stopMeasure(this.customMeasureData());
            List outputMeasures = output.getMeasures();
            this.addCustomTypeToOutputMeasures(outputMeasures);
            this.addAdditionalMeasuresToOutput(output, measurementsBuilder.getMeasures());
            ObjectNode outputPayload = (ObjectNode)this.mapper.valueToTree(output);
            OutputMessageBuilder outputMessageBuilder = new OutputMessageBuilder();
            outputMessageBuilder.setPayload(outputPayload);
            return outputMessageBuilder.build();
        });
    }

    protected void addCustomTypeToOutputMeasures(List<Measure> outputMeasures) {
        if (outputMeasures != null) {
            outputMeasures.forEach(m -> {
                HashMap<String, String> attributes = new HashMap<String, String>();
                if (m.getData() != null) {
                    attributes.putAll(m.getData());
                }
                attributes.putIfAbsent("type", "custom");
                m.setData(attributes);
            });
        }
    }

    protected void addAdditionalMeasuresToOutput(Output<?> output, List<Measure> additionalMeasures) {
        List outputMeasures = output.getMeasures();
        if (outputMeasures == null) {
            output.setMeasures(additionalMeasures);
        } else {
            outputMeasures.addAll(additionalMeasures);
        }
    }

    protected Map<String, Object> customMeasureData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", "keyword");
        return data;
    }

    private Map<String, String> getMergedAgentProperties(AgentTokenWrapper token) {
        Map tokenProperties;
        HashMap<String, String> mergedAgentProperties = new HashMap<String, String>();
        Map agentProperties = token.getServices().getAgentProperties();
        if (agentProperties != null) {
            mergedAgentProperties.putAll(agentProperties);
        }
        if ((tokenProperties = token.getProperties()) != null) {
            mergedAgentProperties.putAll(tokenProperties);
        }
        return mergedAgentProperties;
    }
}

