/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.commons.processes;

import ch.exense.commons.io.FileHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedProcess
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ManagedProcess.class);
    private static final String DEFAULT_PROCESS_NAME = "ManagedProcess";
    private final ProcessBuilder builder;
    private final String id;
    private final File executionDirectory;
    private boolean redirectOuput;
    private Process process;
    private File processOutputLog;
    private File processErrorLog;

    public ManagedProcess(String command) throws ManagedProcessException {
        this(DEFAULT_PROCESS_NAME, ManagedProcess.tokenize(command));
    }

    public ManagedProcess(String name, String command) throws ManagedProcessException {
        this(name, ManagedProcess.tokenize(command));
    }

    public ManagedProcess(List<String> commands) throws ManagedProcessException {
        this(DEFAULT_PROCESS_NAME, commands, null, true);
    }

    public ManagedProcess(String name, List<String> commands) throws ManagedProcessException {
        this(name, commands, null, true);
    }

    public ManagedProcess(List<String> commands, File logDirectory) throws ManagedProcessException {
        this(DEFAULT_PROCESS_NAME, commands, logDirectory, true);
    }

    public ManagedProcess(String name, List<String> commands, File logDirectory, boolean redirectOuput) throws ManagedProcessException {
        this.redirectOuput = redirectOuput;
        if (logDirectory == null) {
            logDirectory = new File(".");
        }
        UUID uuid = UUID.randomUUID();
        this.id = name + "_" + uuid;
        this.builder = new ProcessBuilder(commands);
        this.executionDirectory = new File(logDirectory.getAbsolutePath() + "/" + this.id);
        if (!this.executionDirectory.exists() && !this.executionDirectory.mkdirs()) {
            throw new InvalidParameterException("Unable to create log folder for process " + this.id + ". Please ensure that the folder " + logDirectory.getAbsolutePath() + " exists and is writable.");
        }
    }

    public String getId() {
        return this.id;
    }

    public OutputStream getProcessOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getProcessInputStream() throws Exception {
        if (this.redirectOuput) {
            throw new Exception("The process InputStream could not be retrived if it has been redirected in a file");
        }
        return this.process.getInputStream();
    }

    public File getProcessOutputLog() {
        return this.processOutputLog;
    }

    public File getProcessErrorLog() {
        return this.processErrorLog;
    }

    public File getExecutionDirectory() {
        return this.executionDirectory;
    }

    private static List<String> tokenize(String command) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        Matcher regexMatcher = regex.matcher(command);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                tokens.add(regexMatcher.group(1));
                continue;
            }
            tokens.add(regexMatcher.group());
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ManagedProcessException {
        ManagedProcess managedProcess = this;
        synchronized (managedProcess) {
            try {
                if (this.process == null) {
                    logger.debug("Starting managed process " + this.builder.command());
                    this.builder.directory(this.executionDirectory);
                    if (this.redirectOuput) {
                        this.processOutputLog = new File(this.executionDirectory + "/ProcessOut.log");
                        this.builder.redirectOutput(this.processOutputLog);
                    }
                    this.processErrorLog = new File(this.executionDirectory + "/ProcessError.log");
                    this.builder.redirectError(this.processErrorLog);
                    try {
                        this.process = this.builder.start();
                    }
                    catch (IOException e) {
                        throw new ManagedProcessException("Unable to start the process " + this.id, e);
                    }
                } else {
                    throw new ManagedProcessException("Unable to start the process " + this.id + " twice. The process has already been started.");
                }
                logger.debug("Started managed process " + this.builder.command());
            }
            catch (ManagedProcessException e) {
                throw e;
            }
            catch (Throwable t) {
                this.removeFolder();
            }
        }
    }

    public int waitFor(long timeout) throws TimeoutException, InterruptedException {
        boolean terminated = this.process.waitFor(timeout, TimeUnit.MILLISECONDS);
        if (!terminated) {
            throw new TimeoutException("The process " + this.id + " didn't exit within the defined timeout of " + timeout + "ms");
        }
        return this.process.exitValue();
    }

    @Override
    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            try {
                String errorLog = new String(Files.readAllBytes(this.getProcessErrorLog().toPath()), Charset.defaultCharset());
                logger.debug("Error output from managed process " + this.id + ": " + errorLog);
                logger.debug("End of error output from managed process " + this.id);
                if (this.redirectOuput) {
                    String stdOut = new String(Files.readAllBytes(this.getProcessOutputLog().toPath()), Charset.defaultCharset());
                    logger.debug("Standard output from managed process " + this.id + ": " + stdOut);
                } else {
                    logger.debug("Standard output from managed process " + this.id + " was not redirected, nothing to display.");
                }
                logger.debug("End of standard output from managed process " + this.id);
            }
            catch (IOException e) {
                logger.error("Error while logging output of process " + this.id, e);
            }
        }
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.removeFolder();
    }

    private void removeFolder() {
        try {
            FileHelper.deleteFolder(this.executionDirectory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class ManagedProcessException
    extends Exception {
        private static final long serialVersionUID = -2205566982535606557L;

        public ManagedProcessException(String message, Throwable cause) {
            super(message, cause);
        }

        public ManagedProcessException(String message) {
            super(message);
        }
    }
}

