/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Map;

public class JsonValueSerializer
extends StdSerializer<JsonValue> {
    private static final long serialVersionUID = 1L;

    public JsonValueSerializer() {
        super(JsonValue.class);
    }

    @Override
    public void serialize(JsonValue value, JsonGenerator g, SerializerProvider provider) throws IOException {
        switch (value.getValueType()) {
            case ARRAY: {
                g.writeStartArray();
                this.serializeArrayContents((JsonArray)value, g, provider);
                g.writeEndArray();
                break;
            }
            case OBJECT: {
                g.writeStartObject(value);
                this.serializeObjectContents((JsonObject)value, g, provider);
                g.writeEndObject();
                break;
            }
            default: {
                this.serializeScalar(value, g, provider);
            }
        }
    }

    @Override
    public void serializeWithType(JsonValue value, JsonGenerator g, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonValue.class, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, ctxt);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void serializeScalar(JsonValue value, JsonGenerator g, SerializerProvider provider) throws IOException {
        switch (value.getValueType()) {
            case FALSE: {
                g.writeBoolean(false);
                break;
            }
            case NULL: {
                g.writeNull();
                break;
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                if (num.isIntegral()) {
                    g.writeNumber(num.longValue());
                    break;
                }
                g.writeNumber(num.bigDecimalValue());
                break;
            }
            case STRING: {
                g.writeString(((JsonString)value).getString());
                break;
            }
            case TRUE: {
                g.writeBoolean(true);
                break;
            }
        }
    }

    protected void serializeArrayContents(JsonArray values, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (!values.isEmpty()) {
            for (JsonValue value : values) {
                this.serialize(value, g, provider);
            }
        }
    }

    protected void serializeObjectContents(JsonObject ob, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (!ob.isEmpty()) {
            for (Map.Entry entry : ob.entrySet()) {
                g.writeFieldName((String)entry.getKey());
                this.serialize((JsonValue)entry.getValue(), g, provider);
            }
        }
    }
}

