/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr353;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonValueDeserializer
extends StdDeserializer<JsonValue> {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;
    protected final boolean _forJsonValue;

    @Deprecated
    public JsonValueDeserializer(JsonBuilderFactory bf) {
        this(JsonValue.class, bf);
    }

    public JsonValueDeserializer(Class<?> target, JsonBuilderFactory bf) {
        super(target);
        this._builderFactory = bf;
        this._forJsonValue = target == JsonValue.class;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public JsonValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonValue v;
        switch (p.getCurrentToken()) {
            case START_OBJECT: {
                v = this._deserializeObject(p, ctxt);
                break;
            }
            case START_ARRAY: {
                v = this._deserializeArray(p, ctxt);
                break;
            }
            default: {
                v = this._deserializeScalar(p, ctxt);
            }
        }
        if (!this._forJsonValue && !this.handledType().isAssignableFrom(v.getClass())) {
            ctxt.reportInputMismatch(this.handledType(), "Expected %s, but encountered %s Value", ClassUtil.getClassDescription(this.handledType()), v.getValueType().toString());
        }
        return v;
    }

    @Override
    public JsonValue getNullValue(DeserializationContext ctxt) {
        if (this._forJsonValue) {
            return JsonValue.NULL;
        }
        return null;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeser) throws IOException {
        return typeDeser.deserializeTypedFromScalar(p, ctxt);
    }

    protected JsonObject _deserializeObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonObjectBuilder b = this._builderFactory.createObjectBuilder();
        block15: while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            JsonToken t = p.nextToken();
            switch (t) {
                case START_ARRAY: {
                    b.add(name, this._deserializeArray(p, ctxt));
                    continue block15;
                }
                case START_OBJECT: {
                    b.add(name, this._deserializeObject(p, ctxt));
                    continue block15;
                }
                case VALUE_FALSE: {
                    b.add(name, false);
                    continue block15;
                }
                case VALUE_TRUE: {
                    b.add(name, true);
                    continue block15;
                }
                case VALUE_NULL: {
                    b.addNull(name);
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(name, p.getDecimalValue());
                        continue block15;
                    }
                    b.add(name, p.getDoubleValue());
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(name, p.getLongValue());
                            continue block15;
                        }
                        case INT: {
                            b.add(name, p.getIntValue());
                            continue block15;
                        }
                    }
                    b.add(name, p.getBigIntegerValue());
                    continue block15;
                }
                case VALUE_STRING: {
                    b.add(name, p.getText());
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object ob = p.getEmbeddedObject();
                    if (!(ob instanceof byte[])) break;
                    String b64 = ctxt.getBase64Variant().encode((byte[])ob, false);
                    b.add(name, b64);
                    continue block15;
                }
            }
            return (JsonObject)ctxt.handleUnexpectedToken(JsonObject.class, p);
        }
        return b.build();
    }

    protected JsonArray _deserializeArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
        block14: while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    b.add(this._deserializeArray(p, ctxt));
                    continue block14;
                }
                case START_OBJECT: {
                    b.add(this._deserializeObject(p, ctxt));
                    continue block14;
                }
                case VALUE_FALSE: {
                    b.add(false);
                    continue block14;
                }
                case VALUE_TRUE: {
                    b.add(true);
                    continue block14;
                }
                case VALUE_NULL: {
                    b.addNull();
                    continue block14;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(p.getDecimalValue());
                        continue block14;
                    }
                    b.add(p.getDoubleValue());
                    continue block14;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(p.getLongValue());
                            continue block14;
                        }
                        case INT: {
                            b.add(p.getIntValue());
                            continue block14;
                        }
                    }
                    b.add(p.getBigIntegerValue());
                    continue block14;
                }
                case VALUE_STRING: {
                    b.add(p.getText());
                    continue block14;
                }
            }
            return (JsonArray)ctxt.handleUnexpectedToken(JsonArray.class, p);
        }
        return b.build();
    }

    protected JsonValue _deserializeScalar(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER_FLOAT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return (JsonValue)b.add(p.getDecimalValue()).build().get(0);
                }
                return (JsonValue)b.add(p.getDoubleValue()).build().get(0);
            }
            case VALUE_NUMBER_INT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                switch (p.getNumberType()) {
                    case LONG: {
                        return (JsonValue)b.add(p.getLongValue()).build().get(0);
                    }
                    case INT: {
                        return (JsonValue)b.add(p.getIntValue()).build().get(0);
                    }
                }
                return (JsonValue)b.add(p.getBigIntegerValue()).build().get(0);
            }
            case VALUE_STRING: {
                return (JsonValue)this._builderFactory.createArrayBuilder().add(p.getText()).build().get(0);
            }
        }
        return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
    }
}

