/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.glassfish.json.OutputJsonArrayBuilderImpl;
import org.glassfish.json.OutputJsonObjectBuilderImpl;
import org.glassfish.json.api.BufferPool;

class OutputJsonBuilderFactoryImpl
implements JsonBuilderFactory {
    private final Map<String, ?> config = Collections.emptyMap();
    private final BufferPool bufferPool;
    private final boolean rejectDuplicateKeys;

    OutputJsonBuilderFactoryImpl(BufferPool bufferPool, boolean rejectDuplicateKeys) {
        this.bufferPool = bufferPool;
        this.rejectDuplicateKeys = rejectDuplicateKeys;
    }

    public JsonObjectBuilder createObjectBuilder() {
        return new OutputJsonObjectBuilderImpl(this.bufferPool, this.rejectDuplicateKeys);
    }

    public JsonObjectBuilder createObjectBuilder(JsonObject object) {
        return new OutputJsonObjectBuilderImpl(object, this.bufferPool, this.rejectDuplicateKeys);
    }

    public JsonObjectBuilder createObjectBuilder(Map<String, Object> object) {
        return new OutputJsonObjectBuilderImpl(object, this.bufferPool, this.rejectDuplicateKeys);
    }

    public JsonArrayBuilder createArrayBuilder() {
        return new OutputJsonArrayBuilderImpl(this.bufferPool);
    }

    public JsonArrayBuilder createArrayBuilder(JsonArray array) {
        return new OutputJsonArrayBuilderImpl(array, this.bufferPool);
    }

    public JsonArrayBuilder createArrayBuilder(Collection<?> collection) {
        return new OutputJsonArrayBuilderImpl(collection, this.bufferPool);
    }

    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

