/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.client;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.client.resources.RemoteResourceManager;
import step.functions.packages.FunctionPackage;
import step.functions.packages.client.FunctionPackageClient;
import step.resources.Resource;
import step.resources.SimilarResourceExistingException;

public class RemoteFunctionPackageClientImpl
extends AbstractRemoteClient
implements FunctionPackageClient {
    private RemoteResourceManager remoteResourceManager;

    public RemoteFunctionPackageClientImpl() {
        this.remoteResourceManager = new RemoteResourceManager();
    }

    public RemoteFunctionPackageClientImpl(ControllerCredentials credentials) {
        super(credentials);
        this.remoteResourceManager = new RemoteResourceManager(credentials);
    }

    private FunctionPackage addOrUpdateKeywordPackage(FunctionPackage previousPackage, File packageLibraryFile, File packageFile, Map<String, String> packageAttributes) throws IOException {
        FunctionPackage functionPackage = null;
        functionPackage = previousPackage != null ? previousPackage : new FunctionPackage();
        Resource packageLibraryResource = null;
        if (packageLibraryFile != null) {
            packageLibraryResource = this.upload(packageLibraryFile);
            functionPackage.setPackageLibrariesLocation("resource:" + packageLibraryResource.getId().toString());
        }
        Resource packageResource = this.upload(packageFile);
        functionPackage.setPackageLocation("resource:" + packageResource.getId().toString());
        functionPackage.setPackageAttributes(packageAttributes);
        functionPackage.setWatchForChange(false);
        Invocation.Builder b = this.requestBuilder("/rest/functionpackages/");
        Entity entity = Entity.entity((Object)((Object)functionPackage), (String)"application/json");
        return (FunctionPackage)((Object)((Response)this.executeRequest(() -> b.post(entity))).readEntity(FunctionPackage.class));
    }

    @Override
    public FunctionPackage newKeywordPackage(File packageLibraryFile, File packageFile, Map<String, String> packageAttributes) throws IOException {
        return this.addOrUpdateKeywordPackage(null, packageLibraryFile, packageFile, packageAttributes);
    }

    @Override
    public FunctionPackage updateKeywordPackageById(FunctionPackage previousPackage, File packageLibraryFile, File packageFile, Map<String, String> packageAttributes) throws IOException {
        return this.addOrUpdateKeywordPackage(previousPackage, packageLibraryFile, packageFile, packageAttributes);
    }

    @Override
    public void deleteKeywordPackage(String packlageId) {
        Invocation.Builder b = this.requestBuilder("/rest/functionpackages/" + packlageId);
        this.executeRequest(() -> b.delete());
    }

    @Override
    public FunctionPackage updateResourceBasedKeywordPackage(File packageLibraryFile, File packageFile, Map<String, String> packageAttributes) throws IOException {
        throw new RuntimeException("This service has been removed. Lookup by resourceName isn't supported anymore. Use updateKeywordPackageById instead.");
    }

    @Override
    public FunctionPackage lookupPackageByResourceName(String resourceName) throws IOException {
        throw new RuntimeException("This service has been removed. Lookup by resourceName isn't supported anymore. Use addOrUpdateKeywordPackage instead.");
    }

    protected Resource upload(File file) throws IOException {
        try {
            return this.remoteResourceManager.createResource("functions", (InputStream)new FileInputStream(file), file.getName(), false, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SimilarResourceExistingException e) {
            throw new RuntimeException("Unexpected similar resource error. This should never occur.", e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.remoteResourceManager.close();
    }
}

