/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageAccessor;
import step.functions.packages.FunctionPackageManager;

public class EmbeddedFunctionPackageImporter {
    private static final String PACKAGE_TRACKING_FIELD = "embeddedPackage";
    private static final String META_FILE_EXTENSION = ".json";
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedFunctionPackageImporter.class);
    private final FunctionPackageAccessor functionPackageAccessor;
    private final FunctionPackageManager functionPackageManager;

    public EmbeddedFunctionPackageImporter(FunctionPackageAccessor functionPackageAccessor, FunctionPackageManager functionPackageManager) {
        this.functionPackageAccessor = functionPackageAccessor;
        this.functionPackageManager = functionPackageManager;
    }

    public List<String> importEmbeddedFunctionPackages(@NotNull String packageFolder) {
        assert (packageFolder != null);
        ArrayList<String> importedFunctionPackageIds = new ArrayList<String>();
        importedFunctionPackageIds.addAll(this.importFunctionPackages(packageFolder + "/local", true));
        importedFunctionPackageIds.addAll(this.importFunctionPackages(packageFolder + "/remote", false));
        return importedFunctionPackageIds;
    }

    protected List<String> importFunctionPackages(String embeddedPackageFolder, boolean localExecution) {
        ArrayList<String> importedFunctionPackageIds = new ArrayList<String>();
        File embeddedPackageFolderFile = new File(embeddedPackageFolder);
        if (embeddedPackageFolderFile.exists()) {
            logger.info("Importing function packages from folder " + embeddedPackageFolder);
            Arrays.asList(embeddedPackageFolderFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(EmbeddedFunctionPackageImporter.META_FILE_EXTENSION);
                }
            })).forEach(f -> {
                String packageLocation = f.getAbsolutePath();
                try {
                    FunctionPackage functionPackage = this.searchExistingFunctionPackage((File)f);
                    this.addAttributeFromMetaFileIfAny(packageLocation, functionPackage);
                    importedFunctionPackageIds.add(functionPackage.getId().toString());
                    functionPackage.addCustomField(PACKAGE_TRACKING_FIELD, f);
                    functionPackage.setExecuteLocally(localExecution);
                    this.functionPackageManager.addOrUpdateFunctionPackage(functionPackage);
                }
                catch (Exception e) {
                    logger.error("Error while importing function package " + f.getAbsolutePath(), (Throwable)e);
                }
            });
        } else {
            logger.info("The folder " + embeddedPackageFolderFile.getAbsolutePath() + " doesn't exist");
        }
        return importedFunctionPackageIds;
    }

    private FunctionPackage searchExistingFunctionPackage(File f) throws Exception {
        String packageLocation = f.getAbsolutePath();
        FunctionPackage existingFunctionPackage = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.functionPackageAccessor.getAll(), 16), false).filter(p -> {
            if (f.getName().equals(p.getCustomField(PACKAGE_TRACKING_FIELD))) {
                return true;
            }
            String name = new File(p.getPackageLocation()).getName();
            return f.getName().equals(name);
        }).findFirst().orElse(null);
        if (existingFunctionPackage == null) {
            logger.info("Function package " + packageLocation + " doesn't exist. Creating it...");
            return this.newFunctionPackage(packageLocation);
        }
        logger.info("Function package " + packageLocation + " already exists. Updating it...");
        return existingFunctionPackage;
    }

    private void addAttributeFromMetaFileIfAny(String packageLocation, FunctionPackage functionPackage) throws Exception {
        String metaFileName = packageLocation + META_FILE_EXTENSION;
        File metaFile = new File(metaFileName);
        if (metaFile.exists()) {
            try {
                FunctionPackage metaFunctionPackage = (FunctionPackage)new ObjectMapper().readValue(metaFile, FunctionPackage.class);
                metaFunctionPackage.getAttributes().forEach((key, value) -> functionPackage.addAttribute(key, value));
            }
            catch (IOException e) {
                throw new Exception("Error while reading meta file for package " + packageLocation, e);
            }
        }
    }

    private FunctionPackage newFunctionPackage(String packageLocation) throws Exception {
        FunctionPackage newFunctionPackage = new FunctionPackage();
        newFunctionPackage.setPackageLocation(packageLocation);
        return newFunctionPackage;
    }
}

