/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import ch.exense.commons.io.FileWatchService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageAccessor;
import step.functions.packages.FunctionPackageManager;

public class FunctionPackageChangeWatcher
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FunctionPackageChangeWatcher.class);
    private FileWatchService fileWatchService;
    private FunctionPackageAccessor accessor;
    private FunctionPackageManager packageManager;

    public FunctionPackageChangeWatcher(FunctionPackageAccessor accessor, FunctionPackageManager packageManager, int interval) {
        this.accessor = accessor;
        this.packageManager = packageManager;
        this.fileWatchService = new FileWatchService();
        this.fileWatchService.setInterval(interval);
    }

    public void registerWatchers() {
        Iterator it = this.accessor.getAll();
        while (it.hasNext()) {
            FunctionPackage functionPackage = (FunctionPackage)it.next();
            this.registerWatcherForPackage(functionPackage);
        }
    }

    public void registerWatcherForPackage(FunctionPackage functionPackage) {
        if (functionPackage.isWatchForChange()) {
            File packageFile = this.getWatchedFile(functionPackage);
            this.fileWatchService.register(packageFile, () -> {
                String packageId = functionPackage.getId().toString();
                try {
                    this.packageManager.reloadFunctionPackage(packageId);
                }
                catch (Exception e) {
                    logger.error("Error while reloading function package " + packageId + " based on file " + packageFile.getAbsolutePath(), (Throwable)e);
                }
            }, false);
        }
    }

    private File getWatchedFile(FunctionPackage functionPackage) {
        File packageFile = new File(functionPackage.getPackageLocation());
        return packageFile;
    }

    public void unregisterWatcher(FunctionPackage functionPackage) {
        File packageFile = this.getWatchedFile(functionPackage);
        this.fileWatchService.unregister(packageFile);
    }

    @Override
    public void close() throws IOException {
        this.fileWatchService.close();
    }
}

