/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import step.core.GlobalContext;
import step.core.accessors.Accessor;
import step.core.entities.DependencyTreeVisitorHook;
import step.core.entities.Entity;
import step.core.entities.EntityDependencyTreeVisitor;
import step.core.entities.EntityManager;
import step.functions.Function;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageAccessor;

public class FunctionPackageEntity
extends Entity<FunctionPackage, FunctionPackageAccessor> {
    public static final String FUNCTION_PACKAGE_ID = "functionPackageId";
    public static final String entityName = "functionPackage";

    public FunctionPackageEntity(String name, FunctionPackageAccessor accessor, GlobalContext context) {
        super(name, (Accessor)accessor, FunctionPackage.class);
        EntityManager entityManager = context.getEntityManager();
        entityManager.addDependencyTreeVisitorHook(FunctionPackageEntity.functionReferencesHook(entityManager));
    }

    private static DependencyTreeVisitorHook functionReferencesHook(EntityManager em) {
        return new DependencyTreeVisitorHook(){

            public void onVisitEntity(Object o, EntityDependencyTreeVisitor.EntityTreeVisitorContext context) {
                Function f;
                String id;
                if (o instanceof Function && (id = (String)(f = (Function)o).getCustomField(FunctionPackageEntity.FUNCTION_PACKAGE_ID)) != null) {
                    String newEntityId;
                    if (context.isRecursive()) {
                        context.visitEntity(FunctionPackageEntity.entityName, id);
                    }
                    if ((newEntityId = context.resolvedEntityId(FunctionPackageEntity.entityName, id)) != null) {
                        f.addCustomField(FunctionPackageEntity.FUNCTION_PACKAGE_ID, (Object)newEntityId);
                    }
                }
            }
        };
    }
}

