/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import ch.exense.commons.app.Configuration;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.core.AbstractContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.objectenricher.EnricheableObject;
import step.core.objectenricher.ObjectEnricher;
import step.core.objectenricher.ObjectHookRegistry;
import step.functions.Function;
import step.functions.manager.FunctionManager;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageAccessor;
import step.functions.packages.FunctionPackageChangeWatcher;
import step.functions.packages.FunctionPackageHandler;
import step.functions.packages.UnsupportedFunctionPackageType;
import step.functions.type.FunctionTypeException;
import step.resources.Resource;
import step.resources.ResourceManager;

public class FunctionPackageManager
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(FunctionPackageManager.class);
    private static final String WATCH_FOR_CHANGE = "plugins.FunctionPackagePlugin.watchForChange";
    private static final String WATCHER_INTERVAL = "plugins.FunctionPackagePlugin.watchForChange.interval";
    private final FunctionPackageAccessor functionPackageAccessor;
    private final FunctionManager functionRepository;
    private final ResourceManager resourceManager;
    private final FileResolver fileResolver;
    private FunctionPackageChangeWatcher changeWatcher;
    private final ObjectHookRegistry objectHookRegistry;
    private final List<FunctionPackageHandler> packageHandlers = new ArrayList<FunctionPackageHandler>();
    private final Map<String, java.util.function.Function<String, String>> attributeResolvers = new ConcurrentHashMap<String, java.util.function.Function<String, String>>();

    public FunctionPackageManager(FunctionPackageAccessor functionPackageAccessor, FunctionManager functionRepository, ResourceManager resourceManager, FileResolver fileResolver, Configuration configuration, ObjectHookRegistry objectHookRegistry) {
        this.functionPackageAccessor = functionPackageAccessor;
        this.functionRepository = functionRepository;
        this.resourceManager = resourceManager;
        this.fileResolver = fileResolver;
        this.objectHookRegistry = objectHookRegistry;
        if (configuration.getPropertyAsBoolean(WATCH_FOR_CHANGE, true)) {
            int interval = configuration.getPropertyAsInteger(WATCHER_INTERVAL, Integer.valueOf(60000));
            this.changeWatcher = new FunctionPackageChangeWatcher(functionPackageAccessor, this, interval);
        }
    }

    public void start() {
        if (this.changeWatcher != null) {
            this.changeWatcher.registerWatchers();
        }
    }

    public void registerFunctionPackageHandler(FunctionPackageHandler packageHandler) {
        this.packageHandlers.add(packageHandler);
    }

    public void registerAttributeResolver(String key, java.util.function.Function<String, String> value) {
        this.attributeResolvers.put(key, value);
    }

    public List<Function> getPackagePreview(FunctionPackage functionPackage) throws Exception {
        this.checkPackageValidity(functionPackage);
        FunctionPackageHandler handler = this.getPackageHandler(functionPackage);
        List<Function> functions = handler.buildFunctions(functionPackage, true, null);
        return functions;
    }

    public FunctionPackage addOrUpdateFunctionPackage(FunctionPackage newFunctionPackage) throws Exception {
        this.checkPackageValidity(newFunctionPackage);
        FunctionPackage previousFunctionPackage = null;
        if (newFunctionPackage.getId() != null) {
            previousFunctionPackage = this.get(newFunctionPackage.getId());
            this.cleanupObsoleteResource(previousFunctionPackage, newFunctionPackage);
        }
        return this.addOrUpdateFunctionPackage(previousFunctionPackage, newFunctionPackage);
    }

    public FunctionPackage reloadFunctionPackage(String functionPackageId) throws Exception {
        assert (functionPackageId != null);
        FunctionPackage functionPackage = this.getFunctionPackage(functionPackageId);
        assert (functionPackage != null);
        return this.addOrUpdateFunctionPackage(functionPackage, functionPackage);
    }

    public FunctionPackage getFunctionPackage(String id) {
        return this.get(new ObjectId(id));
    }

    public List<Function> getPackageFunctions(String functionPackageId) {
        return this.getPackageFunctions(this.getFunctionPackage(functionPackageId));
    }

    public void removeFunctionPackage(String id) {
        this.remove(new ObjectId(id));
    }

    @Override
    public void close() throws IOException {
        if (this.changeWatcher != null) {
            this.changeWatcher.close();
        }
    }

    private void checkPackageValidity(FunctionPackage functionPackage) throws Exception {
        if (functionPackage.getPackageLocation() == null) {
            throw new Exception("Invalid package location: resource was null");
        }
        if (functionPackage.getPackageLocation().isEmpty()) {
            throw new Exception("Invalid package location: resource was empty");
        }
    }

    private FunctionPackageHandler getPackageHandler(FunctionPackage functionPackage) throws UnsupportedFunctionPackageType {
        return this.packageHandlers.stream().filter(f -> f.isValidForPackage(functionPackage)).findFirst().orElseThrow(() -> new UnsupportedFunctionPackageType("Unsupported package type: " + functionPackage.getPackageLocation()));
    }

    private void cleanupObsoleteResource(FunctionPackage previousFunctionPackage, FunctionPackage newFunctionPackage) {
        if (previousFunctionPackage != null && newFunctionPackage != null) {
            String newResourceId;
            String previousResourceId;
            if (previousFunctionPackage.getPackageLocation() != null && newFunctionPackage.getPackageLocation() != null) {
                previousResourceId = this.getResourceId(previousFunctionPackage);
                newResourceId = this.getResourceId(newFunctionPackage);
                if (previousResourceId != null && !previousResourceId.equals(newResourceId) && this.resourceManager.resourceExists(previousResourceId)) {
                    this.resourceManager.deleteResource(previousResourceId);
                }
            }
            if (previousFunctionPackage.getPackageLibrariesLocation() != null && newFunctionPackage.getPackageLibrariesLocation() != null) {
                previousResourceId = this.getLibraryResourceId(previousFunctionPackage);
                newResourceId = this.getLibraryResourceId(newFunctionPackage);
                if (previousResourceId != null && !previousResourceId.equals(newResourceId) && this.resourceManager.resourceExists(previousResourceId)) {
                    this.resourceManager.deleteResource(previousResourceId);
                }
            }
        }
    }

    private List<Function> deleteFunctions(FunctionPackage previousFunctionPackage) {
        List<Function> previousFunctions = this.getPackageFunctions(previousFunctionPackage);
        previousFunctions.forEach(function -> {
            try {
                this.functionRepository.deleteFunction(function.getId().toString());
            }
            catch (FunctionTypeException e) {
                logger.error("Error while deleting function " + function.getId().toString(), (Throwable)e);
            }
        });
        return previousFunctions;
    }

    private FunctionPackage addOrUpdateFunctionPackage(FunctionPackage previousFunctionPackage, FunctionPackage newFunctionPackage) throws Exception {
        this.checkPackageValidity(newFunctionPackage);
        FunctionPackageHandler handler = this.getPackageHandler(newFunctionPackage);
        if (newFunctionPackage.getAttributes() != null) {
            newFunctionPackage.setAttributes(newFunctionPackage.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.resolveAttribute((String)e.getKey(), (String)e.getValue()))));
        }
        AbstractContext context = new AbstractContext(){};
        this.objectHookRegistry.rebuildContext(context, (EnricheableObject)newFunctionPackage);
        ObjectEnricher objectEnricher = this.objectHookRegistry.getObjectEnricher(context);
        List<Function> previousFunctions = null;
        if (previousFunctionPackage != null) {
            previousFunctions = this.deleteFunctions(previousFunctionPackage);
            this.unregisterWatcher(previousFunctionPackage);
        }
        List<Function> functions = handler.buildFunctions(newFunctionPackage, false, objectEnricher);
        ArrayList<ObjectId> newFunctionIds = new ArrayList<ObjectId>();
        for (Function newFunction : functions) {
            if (newFunctionPackage.getPackageAttributes() != null) {
                newFunction.getAttributes().putAll(newFunctionPackage.getPackageAttributes());
            }
            objectEnricher.accept((Object)newFunction);
            if (previousFunctions != null) {
                previousFunctions.stream().filter(f -> f.getAttribute("name").equals(newFunction.getAttribute("name"))).findFirst().ifPresent(oldFunction -> newFunction.setId(oldFunction.getId()));
            }
            newFunction.setManaged(true);
            newFunction.setExecuteLocally(newFunctionPackage.isExecuteLocally());
            newFunction.setTokenSelectionCriteria(newFunctionPackage.getTokenSelectionCriteria());
            newFunction.addCustomField("functionPackageId", (Object)newFunctionPackage.getId().toString());
            this.functionRepository.saveFunction(newFunction);
            newFunctionIds.add(newFunction.getId());
        }
        newFunctionPackage.setFunctions(newFunctionIds);
        String name = this.buildFunctionPackageName(newFunctionPackage);
        newFunctionPackage.addAttribute("name", name);
        this.registerWatcher(newFunctionPackage);
        newFunctionPackage = (FunctionPackage)this.functionPackageAccessor.save((AbstractIdentifiableObject)newFunctionPackage);
        return newFunctionPackage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String buildFunctionPackageName(FunctionPackage newFunctionPackage) {
        String resourceId = this.getResourceId(newFunctionPackage);
        if (resourceId != null) {
            Resource mainResource = this.resourceManager.getResource(resourceId);
            if (mainResource == null) throw new RuntimeException("The resource with id " + resourceId + " could not be found");
            return mainResource.getResourceName();
        }
        Path p = Paths.get(newFunctionPackage.getPackageLocation(), new String[0]);
        return p.getFileName().toString();
    }

    private String resolveAttribute(String key, String value) {
        java.util.function.Function<String, String> attributeResolver = this.attributeResolvers.get(key);
        if (attributeResolver != null) {
            if (value != null && value.startsWith("@")) {
                String valueToBeResolved = value.replaceFirst("@", "");
                String resolvedValue = attributeResolver.apply(valueToBeResolved);
                return resolvedValue;
            }
            return value;
        }
        return value;
    }

    private void registerWatcher(FunctionPackage functionPackage) {
        if (this.changeWatcher != null && !this.fileResolver.isResource(functionPackage.getPackageLocation())) {
            functionPackage.setWatchForChange(true);
            this.changeWatcher.registerWatcherForPackage(functionPackage);
        }
    }

    private void unregisterWatcher(FunctionPackage functionPackage) {
        if (this.changeWatcher != null && !this.fileResolver.isResource(functionPackage.getPackageLocation())) {
            this.changeWatcher.unregisterWatcher(functionPackage);
        }
    }

    private String getLibraryResourceId(FunctionPackage fpackage) {
        return this.resolveResourceId(fpackage.getPackageLibrariesLocation());
    }

    private String getResourceId(FunctionPackage fpackage) {
        return this.resolveResourceId(fpackage.getPackageLocation());
    }

    private String resolveResourceId(String resourceLocation) {
        return this.fileResolver.resolveResourceId(resourceLocation);
    }

    private List<Function> getPackageFunctions(FunctionPackage functionPackage) {
        return functionPackage.functions.stream().map(id -> this.functionRepository.getFunctionById(id.toString())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private FunctionPackage get(ObjectId id) {
        return (FunctionPackage)this.functionPackageAccessor.get(id);
    }

    private void remove(ObjectId id) {
        FunctionPackage functionPackage = (FunctionPackage)this.functionPackageAccessor.get(id);
        this.deleteFunctions(functionPackage);
        this.unregisterWatcher(functionPackage);
        this.functionPackageAccessor.remove(id);
        this.deleteResource(functionPackage.getPackageLocation());
        this.deleteResource(functionPackage.getPackageLibrariesLocation());
    }

    private void deleteResource(String path) {
        String resolveResourceId = this.fileResolver.resolveResourceId(path);
        if (resolveResourceId != null) {
            try {
                this.resourceManager.deleteResource(resolveResourceId);
            }
            catch (RuntimeException e) {
                logger.warn("Dirty cleanup of FunctionPackage: an error occured while deleting one of the associated resources.", (Throwable)e);
            }
        }
    }
}

