/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import ch.exense.commons.app.Configuration;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.collections.Collection;
import step.core.deployment.ObjectHookControllerPlugin;
import step.core.entities.Entity;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.AbstractWebPlugin;
import step.core.plugins.Plugin;
import step.core.plugins.WebPlugin;
import step.framework.server.tables.Table;
import step.framework.server.tables.TableRegistry;
import step.functions.manager.FunctionManager;
import step.functions.packages.EmbeddedFunctionPackageImporter;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageAccessor;
import step.functions.packages.FunctionPackageAccessorImpl;
import step.functions.packages.FunctionPackageEntity;
import step.functions.packages.FunctionPackageManager;
import step.functions.packages.FunctionPackageServices;
import step.functions.packages.handlers.JavaFunctionPackageHandler;
import step.functions.packages.handlers.RepositoryArtifactFunctionPackageHandler;
import step.functions.plugin.FunctionControllerPlugin;
import step.plugins.java.GeneralScriptFunctionControllerPlugin;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.InputType;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplatePlugin;
import step.resources.ResourceManager;
import step.resources.ResourceManagerControllerPlugin;

@Plugin(dependencies={ObjectHookControllerPlugin.class, ResourceManagerControllerPlugin.class, FunctionControllerPlugin.class, ScreenTemplatePlugin.class, GeneralScriptFunctionControllerPlugin.class})
public class FunctionPackagePlugin
extends AbstractControllerPlugin {
    public static final String FUNCTION_TABLE_EXTENSIONS = "functionTableExtensions";
    private static final Logger logger = LoggerFactory.getLogger(FunctionPackagePlugin.class);
    private FunctionPackageManager packageManager;
    private FunctionManager functionManager;
    private FunctionPackageAccessor packageAccessor;

    public void serverStart(GlobalContext context) throws Exception {
        FileResolver fileResolver = context.getFileResolver();
        ResourceManager resourceManager = context.getResourceManager();
        this.packageAccessor = new FunctionPackageAccessorImpl((Collection<FunctionPackage>)context.getCollectionFactory().getCollection("functionPackage", FunctionPackage.class));
        Configuration configuration = context.getConfiguration();
        this.functionManager = (FunctionManager)context.get(FunctionManager.class);
        ObjectHookRegistry objectHookRegistry = (ObjectHookRegistry)context.require(ObjectHookRegistry.class);
        this.packageManager = new FunctionPackageManager(this.packageAccessor, this.functionManager, resourceManager, fileResolver, configuration, objectHookRegistry);
        this.packageManager.registerFunctionPackageHandler(new JavaFunctionPackageHandler(fileResolver, configuration));
        this.packageManager.registerFunctionPackageHandler(new RepositoryArtifactFunctionPackageHandler(resourceManager, fileResolver, configuration));
        this.packageManager.start();
        context.put(FunctionPackageManager.class, (Object)this.packageManager);
        Collection functionPackageCollection = context.getCollectionFactory().getCollection("functionPackage", FunctionPackage.class);
        Table collection = new Table(functionPackageCollection, "kw-read", true);
        ((TableRegistry)context.get(TableRegistry.class)).register("functionPackage", collection);
        context.getServiceRegistrationCallback().registerService(FunctionPackageServices.class);
        context.getEntityManager().register((Entity)new FunctionPackageEntity("functionPackage", this.packageAccessor, context));
    }

    public void initializeData(GlobalContext context) throws Exception {
        this.createScreenInputsIfNecessary(context);
        Configuration configuration = context.getConfiguration();
        String embeddedPackageFolder = configuration.getProperty("plugins.FunctionPackagePlugin.embeddedpackages.folder");
        if (embeddedPackageFolder != null) {
            EmbeddedFunctionPackageImporter embeddedFunctionPackageImporter = new EmbeddedFunctionPackageImporter(this.packageAccessor, this.packageManager);
            embeddedFunctionPackageImporter.importEmbeddedFunctionPackages(embeddedPackageFolder);
        }
    }

    protected void createScreenInputsIfNecessary(GlobalContext context) {
        ScreenInputAccessor screenInputAccessor = (ScreenInputAccessor)context.get(ScreenInputAccessor.class);
        List functionTableExtensions = screenInputAccessor.getScreenInputsByScreenId(FUNCTION_TABLE_EXTENSIONS);
        boolean inputExist = functionTableExtensions.stream().filter(i -> i.getInput().getId().equals("customFields.functionPackageId")).findFirst().isPresent();
        if (!inputExist) {
            Input input = new Input(InputType.TEXT, "customFields.functionPackageId", "Package", "", null);
            input.setCustomUIComponents(List.of("functionPackageLink"));
            input.setSearchMapperService("rest/table/functionPackage/searchIdsBy/attributes.name");
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(FUNCTION_TABLE_EXTENSIONS, input));
        }
    }

    public void serverStop(GlobalContext context) {
        try {
            this.packageManager.close();
        }
        catch (IOException e) {
            logger.error("Error while closing package manager", (Throwable)e);
        }
    }

    public AbstractWebPlugin getWebPlugin() {
        WebPlugin webPlugin = new WebPlugin();
        webPlugin.getAngularModules().add("functionPackages");
        webPlugin.getScripts().add("functionpackages/js/controllers/functionPackages.js");
        return webPlugin;
    }
}

