/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.deployment.AbstractStepServices;
import step.framework.server.security.Secured;
import step.functions.Function;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageManager;

@Path(value="/functionpackages")
@Tag(name="Keyword packages")
public class FunctionPackageServices
extends AbstractStepServices {
    private static final Logger logger = LoggerFactory.getLogger(FunctionPackageServices.class);
    protected FunctionPackageManager functionPackageManager;

    @PostConstruct
    public void init() {
        this.functionPackageManager = (FunctionPackageManager)this.getContext().get(FunctionPackageManager.class);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Secured(right="kw-read")
    public FunctionPackage getFunctionPackage(@PathParam(value="id") String functionPackageId) {
        return this.functionPackageManager.getFunctionPackage(functionPackageId);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Secured(right="kw-write")
    public void deleteFunctionPackage(@PathParam(value="id") String functionPackageId) {
        this.functionPackageManager.removeFunctionPackage(functionPackageId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/preview")
    @Secured(right="kw-write")
    public PackagePreview packagePreview(FunctionPackage functionPackage) {
        try {
            List<Function> functions = this.functionPackageManager.getPackagePreview(functionPackage);
            return new PackagePreview(functions);
        }
        catch (Exception e) {
            logger.warn("Error while loading package preview for function package " + functionPackage, (Throwable)e);
            return new PackagePreview(e.getMessage());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="kw-write")
    public FunctionPackage saveFunctionPackage(FunctionPackage functionPackage, @Context UriInfo uriInfo) throws Exception {
        return this.functionPackageManager.addOrUpdateFunctionPackage(functionPackage);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/resourcebased")
    @Secured(right="kw-write")
    public FunctionPackage updateFunctionPackage(FunctionPackage functionPackage, @Context UriInfo uriInfo) throws Exception {
        throw new Exception("This service has been removed. Use POST /rest/functionpackages/ instead. Lookup by resourceName isn't supported anymore");
    }

    @GET
    @Path(value="/resourcebased/lookup/{resourceName}")
    @Produces(value={"application/json"})
    @Secured(right="kw-read")
    public FunctionPackage lookupByResourceName(@PathParam(value="resourceName") String resourceName) throws Exception {
        throw new Exception("This service has been removed. Lookup by resourceName isn't supported anymore. Use GET /rest/functionpackages/{id} instead.");
    }

    @GET
    @Path(value="/{id}/functions")
    @Produces(value={"application/json"})
    @Secured(right="kw-write")
    public List<Function> getPackageFunctions(@PathParam(value="id") String functionPackageId) {
        return this.functionPackageManager.getPackageFunctions(functionPackageId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/reload")
    @Secured(right="kw-write")
    public FunctionPackage reloadFunctionPackage(@PathParam(value="id") String functionPackageId, @Context UriInfo uriInfo) throws Exception {
        return this.functionPackageManager.reloadFunctionPackage(functionPackageId);
    }

    public static class PackagePreview {
        private String loadingError;
        private List<Function> functions;

        public PackagePreview(List<Function> functions) {
            this.functions = functions;
        }

        public PackagePreview(String loadingError) {
            this.loadingError = loadingError;
        }

        public String getLoadingError() {
            return this.loadingError;
        }

        public void setLoadingError(String loadingError) {
            this.loadingError = loadingError;
        }

        public List<Function> getFunctions() {
            return this.functions;
        }

        public void setFunctions(List<Function> functions) {
            this.functions = functions;
        }
    }
}

