/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.handlers;

import ch.exense.commons.processes.ManagedProcess;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.core.objectenricher.ObjectEnricher;
import step.functions.Function;
import step.functions.packages.FunctionPackage;
import step.functions.packages.FunctionPackageHandler;
import step.functions.packages.handlers.FunctionList;
import step.functions.packages.handlers.FunctionPackageUtils;
import step.functions.packages.handlers.ObjectMapperResolver;

public abstract class AbstractFunctionPackageHandler
extends FunctionPackageUtils
implements FunctionPackageHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFunctionPackageHandler.class);

    public AbstractFunctionPackageHandler(FileResolver fileResolver) {
        super(fileResolver);
    }

    @Override
    public abstract boolean isValidForPackage(FunctionPackage var1);

    @Override
    public abstract List<Function> buildFunctions(FunctionPackage var1, boolean var2, ObjectEnricher var3) throws Exception;

    protected List<Function> getFunctionsFromDaemon(FunctionPackage functionPackage, ManagedProcess discovererDeamon) throws Exception {
        FunctionList list;
        File packageFile = this.resolveMandatoryFile(functionPackage.getPackageLocation());
        File packageLibraryFile = this.resolveFile(functionPackage.getPackageLibrariesLocation());
        FunctionPackageUtils.DiscovererParameters param = new FunctionPackageUtils.DiscovererParameters();
        if (packageFile == null) {
            throw new FileNotFoundException("The package location doesn't exist");
        }
        param.packageLocation = packageFile.getAbsolutePath();
        param.packageLibrariesLocation = packageLibraryFile != null ? packageLibraryFile.getAbsolutePath() : "";
        ObjectMapperResolver resolver = new ObjectMapperResolver();
        ObjectMapper objectMapper = resolver.getContext(FunctionList.class);
        try (OutputStream outputStream = discovererDeamon.getProcessOutputStream();){
            String serializedRequest = objectMapper.writeValueAsString((Object)param);
            outputStream.write(serializedRequest.getBytes());
        }
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(discovererDeamon.getProcessInputStream()));){
            String res;
            do {
                if ((res = inputStream.readLine()) != null) continue;
                logger.error("Unexpected error when starting the function package handler: '" + discovererDeamon.getProcessErrorLogAsString() + "'");
                throw new Exception("Unexpected error when starting the function package handler: the process exited before returning the result. See the logs on the controller for more detail");
            } while (!res.equals("READY"));
            list = (FunctionList)objectMapper.readValue((Reader)inputStream, FunctionList.class);
        }
        if (list.exception == null) {
            ArrayList<Function> functions = list.getFunctions();
            functions.forEach(f -> this.configureFunction((Function)f, functionPackage));
            return list.getFunctions();
        }
        throw new Exception(list.exception);
    }

    protected abstract void configureFunction(Function var1, FunctionPackage var2);
}

