/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import step.attachments.FileResolver;

public class FunctionPackageUtils {
    protected static final String READY_STRING = "READY";
    protected final FileResolver fileResolver;

    public FunctionPackageUtils(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    protected File resolveMandatoryFile(String resource) throws FileNotFoundException {
        File file = this.resolveFile(resource);
        if (file == null) {
            throw new FileNotFoundException("The resource " + resource + " doesn't exist");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The file " + file + " doesn't exist");
        }
        return file;
    }

    protected File resolveFile(String resource) {
        File file = null;
        if (resource != null && !resource.isBlank()) {
            file = this.fileResolver.resolve(resource);
        }
        return file;
    }

    public static class DiscovererParameters {
        public String packageLibrariesLocation;
        public String packageLocation;

        public String getPackageLibrariesLocation() {
            return this.packageLibrariesLocation;
        }

        public void setPackageLibrariesLocation(String packageLibrariesLocation) {
            this.packageLibrariesLocation = packageLibrariesLocation;
        }

        public String getPackageLocation() {
            return this.packageLocation;
        }

        public void setPackageLocation(String packageLocation) {
            this.packageLocation = packageLocation;
        }
    }
}

