/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.handlers;

import ch.exense.commons.app.Configuration;
import ch.exense.commons.processes.ExternalJVMLauncher;
import ch.exense.commons.processes.ManagedProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import step.attachments.FileResolver;
import step.core.dynamicbeans.DynamicValue;
import step.core.objectenricher.ObjectEnricher;
import step.functions.Function;
import step.functions.packages.FunctionPackage;
import step.functions.packages.handlers.AbstractFunctionPackageHandler;
import step.functions.packages.handlers.JavaFunctionPackageDaemon;
import step.plugins.java.GeneralScriptFunction;

public class JavaFunctionPackageHandler
extends AbstractFunctionPackageHandler {
    private File processLogFolder;
    private String javaPath = System.getProperty("java.home") + "/bin/java";

    public JavaFunctionPackageHandler(FileResolver fileResolver, Configuration config) {
        super(fileResolver);
        String logs = "../log/functionDiscoverer_java";
        this.processLogFolder = new File(logs);
    }

    @Override
    public List<Function> buildFunctions(FunctionPackage functionPackage, boolean preview, ObjectEnricher objectEnricher) throws Exception {
        ExternalJVMLauncher launcher = new ExternalJVMLauncher(this.javaPath, this.processLogFolder);
        ArrayList vmargs = new ArrayList();
        ArrayList progargs = new ArrayList();
        try (ManagedProcess process = launcher.launchExternalJVM("Java Function Discoverer", JavaFunctionPackageDaemon.class, vmargs, progargs, false);){
            List<Function> list = this.getFunctionsFromDaemon(functionPackage, process);
            return list;
        }
    }

    @Override
    protected void configureFunction(Function f, FunctionPackage functionPackage) {
        GeneralScriptFunction function = (GeneralScriptFunction)f;
        function.setScriptLanguage(new DynamicValue((Object)"java"));
        function.setScriptFile(new DynamicValue((Object)functionPackage.getPackageLocation()));
        function.setLibrariesFile(new DynamicValue((Object)functionPackage.getPackageLibrariesLocation()));
    }

    @Override
    public boolean isValidForPackage(FunctionPackage functionPackage) {
        File file = this.resolveFile(functionPackage.getPackageLocation());
        String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        return extension.equals("jar");
    }
}

