/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsonp.JSONPModule;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.bson.types.ObjectId;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ObjectMapperResolver
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper mapper;

    public ObjectMapperResolver() {
        SimpleModule module = new SimpleModule("ObjectIdmodule");
        module.addSerializer(ObjectId.class, (JsonSerializer)new ObjectIdSerializer());
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JSONPModule());
        this.mapper.registerModule((Module)module);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    public class ObjectIdSerializer
    extends JsonSerializer<ObjectId> {
        public void serialize(ObjectId value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.toString());
        }
    }
}

