/*
 * Decompiled with CFR 0.152.
 */
package step.functions.packages.handlers;

import ch.exense.commons.app.Configuration;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.attachments.FileResolver;
import step.core.objectenricher.ObjectEnricher;
import step.functions.Function;
import step.functions.packages.FunctionPackage;
import step.functions.packages.handlers.JavaFunctionPackageHandler;
import step.resources.Resource;
import step.resources.ResourceManager;

public class RepositoryArtifactFunctionPackageHandler
extends JavaFunctionPackageHandler {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryArtifactFunctionPackageHandler.class);
    private ResourceManager resourceManager;
    private RepositorySystem repositorySystem;
    private List<RemoteRepository> repositories;
    private LocalRepository localRepository;

    public RepositoryArtifactFunctionPackageHandler(ResourceManager resourceManager, FileResolver fileResolver, Configuration config) {
        super(fileResolver, config);
        this.resourceManager = resourceManager;
        this.repositorySystem = this.newRepositorySystem();
        this.localRepository = new LocalRepository(config.getProperty("plugins.FunctionPackagePlugin.maven.localrepository", "maven"));
        this.parseConfigurationAndCreateRepositoryList(config);
    }

    private void parseConfigurationAndCreateRepositoryList(Configuration config) {
        HashMap repositoriesProperties = new HashMap();
        config.getPropertyNames().forEach(p -> {
            String key = p.toString();
            if (key.startsWith("plugins.FunctionPackagePlugin.maven.repository.")) {
                String repositoryId = key.replace("plugins.FunctionPackagePlugin.maven.repository.", "").split("\\.")[0];
                Map repositoryProperties = repositoriesProperties.computeIfAbsent(repositoryId, k -> new HashMap());
                String propertyKey = key.replace("plugins.FunctionPackagePlugin.maven.repository." + repositoryId + ".", "");
                repositoryProperties.put(propertyKey, config.getProperty(key));
            }
        });
        this.repositories = new ArrayList<RemoteRepository>();
        repositoriesProperties.entrySet().forEach(e -> {
            String proxyType;
            Map properties = (Map)e.getValue();
            String url = (String)properties.get("url");
            String username = (String)properties.get("username");
            String password = (String)properties.get("password");
            RemoteRepository.Builder builder = new RemoteRepository.Builder((String)e.getKey(), "default", url);
            if (username != null) {
                Authentication authentication = new AuthenticationBuilder().addUsername(username).addPassword(password).build();
                builder.setAuthentication(authentication);
            }
            if ((proxyType = (String)properties.get("proxy.type")) != null) {
                String proxyHost = (String)properties.get("proxy.host");
                int proxyPort = Integer.parseInt((String)properties.get("proxy.port"));
                String proxyUsername = (String)properties.get("proxy.username");
                String proxyPassword = (String)properties.get("proxy.password");
                Authentication authentication = null;
                if (proxyUsername != null) {
                    authentication = new AuthenticationBuilder().addUsername(proxyUsername).addPassword(proxyPassword).build();
                }
                Proxy proxy = new Proxy(proxyType, proxyHost, proxyPort, authentication);
                builder.setProxy(proxy);
            }
            RemoteRepository remoteRepository = builder.build();
            this.repositories.add(remoteRepository);
        });
    }

    @Override
    public boolean isValidForPackage(FunctionPackage functionPackag) {
        return functionPackag.getPackageLocation().contains("<dependency>");
    }

    @Override
    public List<Function> buildFunctions(FunctionPackage functionPackage, boolean preview, ObjectEnricher objectEnricher) throws Exception {
        String packageLocation = functionPackage.getPackageLocation();
        XmlMapper mapper = new XmlMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Dependency dependency = (Dependency)mapper.readValue(packageLocation, Dependency.class);
        DefaultArtifact artifact = new DefaultArtifact(dependency.groupId, dependency.artifactId, dependency.classifier, "jar", dependency.version);
        File artifactFile = this.getArtifactByAether((Artifact)artifact);
        if (preview) {
            functionPackage.setPackageLocation(artifactFile.getAbsolutePath());
        } else {
            Resource resource = this.resourceManager.createResource("functions", (InputStream)new FileInputStream(artifactFile), artifactFile.getName(), false, objectEnricher);
            functionPackage.setPackageLocation("resource:" + resource.getId().toString());
            functionPackage.addAttribute("version", artifact.getVersion());
        }
        List<Function> functions = super.buildFunctions(functionPackage, preview, objectEnricher);
        return functions;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession newSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, this.localRepository));
        return session;
    }

    private File getArtifactByAether(Artifact artifact) throws IOException, ArtifactResolutionException {
        RepositorySystemSession session = this.newSession();
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setRepositories(this.repositories);
        ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(session, artifactRequest);
        Artifact resolvedArtifact = artifactResult.getArtifact();
        if (resolvedArtifact == null) {
            artifactResult.getExceptions().forEach(e -> logger.error("Error while resolving artifact " + artifact.toString(), (Throwable)e));
            throw new RuntimeException("The resolution of the artifact failed. See the logs for more details");
        }
        File result = resolvedArtifact.getFile();
        return result;
    }

    protected static class Dependency {
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;

        protected Dependency() {
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }
    }
}

