/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import ch.exense.commons.app.Configuration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import step.functions.type.AbstractFunctionType;
import step.grid.filemanager.FileVersionId;
import step.plugins.jmeter.JMeterFunction;

public class JMeterFunctionType
extends AbstractFunctionType<JMeterFunction> {
    FileVersionId handlerJar;
    protected final Configuration configuration;

    public JMeterFunctionType(Configuration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        super.init();
        this.handlerJar = this.registerResource(((Object)((Object)this)).getClass().getClassLoader(), "jmeter-plugin-handler.jar", false);
    }

    public String getHandlerChain(JMeterFunction function) {
        return "step.plugins.jmeter.JMeterHandler";
    }

    public FileVersionId getHandlerPackage(JMeterFunction function) {
        return this.handlerJar;
    }

    public Map<String, String> getHandlerProperties(JMeterFunction function) {
        HashMap<String, String> props = new HashMap<String, String>();
        this.registerFile(function.getJmeterTestplan(), "$jmeter.testplan.file", props);
        String home = this.configuration.getProperty("plugins.jmeter.home");
        if (home != null) {
            File homeFile = new File(home);
            this.registerFile(homeFile, "$jmeter.libraries", props);
            return props;
        }
        throw new RuntimeException("Property 'plugins.jmeter.home' in step.properties isn't set. Please set it to path of the home folder of JMeter");
    }

    public JMeterFunction newFunction() {
        return new JMeterFunction();
    }
}

