/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import ch.exense.commons.app.Configuration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.AbstractStepContext;
import step.functions.Function;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeException;
import step.grid.filemanager.FileVersionId;
import step.plugins.jmeter.JMeterFunction;
import step.resources.ResourceManager;

public class JMeterFunctionType
extends AbstractFunctionType<JMeterFunction> {
    private static final Logger log = LoggerFactory.getLogger(JMeterFunctionType.class);
    public static final String JMETER_HOME_CONFIG_PROPERTY = "plugins.jmeter.home";
    private FileVersionId handlerJar;
    protected final Configuration configuration;

    public JMeterFunctionType(Configuration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        super.init();
        this.handlerJar = this.registerResource(((Object)((Object)this)).getClass().getClassLoader(), "jmeter-plugin-handler.jar", false);
    }

    public String getHandlerChain(JMeterFunction function) {
        return "step.plugins.jmeter.JMeterHandler";
    }

    public FileVersionId getHandlerPackage(JMeterFunction function) {
        return this.handlerJar;
    }

    public Map<String, String> getHandlerProperties(JMeterFunction function, AbstractStepContext executionContext) {
        HashMap<String, String> props = new HashMap<String, String>();
        this.registerFile(function.getJmeterTestplan(), "$jmeter.testplan.file", props, true, executionContext);
        String home = this.configuration.getProperty(JMETER_HOME_CONFIG_PROPERTY);
        if (home != null) {
            File homeFile = new File(home);
            this.registerFile(homeFile, "$jmeter.libraries", props);
            return props;
        }
        throw new RuntimeException("Property 'plugins.jmeter.home' in step.properties isn't set. Please set it to path of the home folder of JMeter");
    }

    public JMeterFunction newFunction() {
        return new JMeterFunction();
    }

    public void deleteFunction(JMeterFunction function) throws FunctionTypeException {
        String jmeterTestplanResourceId;
        if (function.isManaged() && (jmeterTestplanResourceId = (String)function.getJmeterTestplan().getValue()) != null && !jmeterTestplanResourceId.isEmpty()) {
            ResourceManager resourceManager = this.getResourceManager(null);
            if (resourceManager != null) {
                resourceManager.deleteResource(jmeterTestplanResourceId);
            } else {
                log.warn("Unable to cleanup the jmeter testplan resource for function " + function.getId().toString() + ". Resource manager is not available");
            }
        }
        super.deleteFunction((Function)function);
    }
}

