/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import ch.exense.commons.app.Configuration;
import step.core.execution.AbstractExecutionEngineContext;
import step.core.execution.ExecutionEngineContext;
import step.core.execution.OperationMode;
import step.core.plugins.Plugin;
import step.engine.plugins.AbstractExecutionEnginePlugin;
import step.engine.plugins.FunctionPlugin;
import step.functions.type.AbstractFunctionType;
import step.functions.type.FunctionTypeRegistry;
import step.plugins.jmeter.JMeterFunctionType;

@Plugin(dependencies={FunctionPlugin.class})
public class JMeterFunctionTypeLocalPlugin
extends AbstractExecutionEnginePlugin {
    public static final String JMETER_HOME_ENV_VAR = "JMETER_HOME";
    private FunctionTypeRegistry functionTypeRegistry;

    public void initializeExecutionEngineContext(AbstractExecutionEngineContext parentContext, ExecutionEngineContext context) {
        if (context.getOperationMode() == OperationMode.LOCAL) {
            Configuration config = context.getConfiguration();
            String jMeterHome = System.getenv().get(JMETER_HOME_ENV_VAR);
            if (jMeterHome != null) {
                config.putProperty("plugins.jmeter.home", jMeterHome);
            }
            this.functionTypeRegistry = (FunctionTypeRegistry)context.require(FunctionTypeRegistry.class);
            this.functionTypeRegistry.registerFunctionType((AbstractFunctionType)new JMeterFunctionType(context.getConfiguration()));
        }
    }
}

