/*
 * Decompiled with CFR 0.152.
 */
package step.grid.app.configuration;

import ch.exense.commons.app.ArgumentParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import step.grid.app.configuration.AppConfiguration;

public class ConfigurationParser<T extends AppConfiguration> {
    private static final String JSON = "json";
    private static final String YAML = "yaml";

    public T parse(ArgumentParser arguments, File file, Class<T> clazz) throws Exception {
        ObjectMapper mapper;
        byte[] bytes = Files.readAllBytes(file.toPath());
        String content = new String(bytes);
        String resolvedContent = this.replacePlaceholders(arguments, content);
        if (file.getName().endsWith(YAML)) {
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else if (file.getName().endsWith(JSON)) {
            mapper = new ObjectMapper();
        } else {
            throw new IllegalArgumentException("Unsupported file type for agent configuration: " + file.getAbsolutePath() + ". Supported file types are .yaml and .json");
        }
        return (T)((AppConfiguration)mapper.readValue(resolvedContent, clazz));
    }

    private String replacePlaceholders(ArgumentParser arguments, String configXml) {
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\$\\{(.+?)\\}").matcher(configXml);
        while (m.find()) {
            String key = m.group(1);
            String replacement = arguments.getOption(key);
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

