/*
 * Decompiled with CFR 0.152.
 */
package step.grid.app.server;

import io.prometheus.client.hotspot.DefaultExports;
import io.prometheus.client.servlet.jakarta.exporter.MetricsServlet;
import jakarta.servlet.Servlet;
import java.net.Inet4Address;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.app.configuration.AppConfiguration;

public class BaseServer {
    private static final Logger logger = LoggerFactory.getLogger(BaseServer.class);

    protected Server startServer(AppConfiguration appConfiguration, int port, ResourceConfig resourceConfig) throws Exception {
        ServerConnector connector;
        resourceConfig.register(JacksonJsonProvider.class);
        resourceConfig.register(JacksonFeature.class);
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(sh, "/*");
        Server server = new Server();
        if (appConfiguration.isSsl()) {
            String keyStorePath = appConfiguration.getKeyStorePath();
            String keyStorePassword = appConfiguration.getKeyStorePassword();
            String keyManagerPassword = appConfiguration.getKeyManagerPassword();
            HttpConfiguration https = new HttpConfiguration();
            SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
            secureRequestCustomizer.setSniHostCheck(false);
            https.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keyStorePath);
            sslContextFactory.setKeyStorePassword(keyStorePassword);
            sslContextFactory.setKeyManagerPassword(keyManagerPassword);
            connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        } else {
            HttpConfiguration http = new HttpConfiguration();
            http.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(server);
            connector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(http));
        }
        connector.setPort(port);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)context);
        this.addMetricServletIfRequired(appConfiguration, contexts);
        server.setHandler((Handler)contexts);
        server.start();
        return server;
    }

    private void addMetricServletIfRequired(AppConfiguration appConfiguration, ContextHandlerCollection handlers) {
        if (appConfiguration.isExposeMetrics()) {
            ServletContextHandler servletContext = new ServletContextHandler();
            servletContext.setContextPath("/metrics");
            servletContext.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "");
            DefaultExports.initialize();
            handlers.addHandler((Handler)servletContext);
            logger.info("Exposing prometheus JVM metrics under path '/metrics'");
        }
    }

    protected int resolveServerPort(String configUrl, Integer configPort) throws MalformedURLException {
        URL url;
        int urlPort;
        int port = configPort != null ? configPort : (configUrl != null ? ((urlPort = (url = new URL(configUrl)).getPort()) != -1 ? urlPort : url.getDefaultPort()) : 0);
        return port;
    }

    protected int getActualServerPort(Server server) {
        return ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }

    protected String getOrBuildActualUrl(String serverHost, String serverUrl, int localPort, boolean ssl) throws UnknownHostException {
        Object actualAgentUrl;
        if (serverUrl == null) {
            String scheme = ssl ? "https://" : "http://";
            String host = serverHost == null ? Inet4Address.getLocalHost().getCanonicalHostName() : serverHost;
            actualAgentUrl = scheme + host + ":" + localPort;
        } else {
            actualAgentUrl = serverUrl;
        }
        return actualAgentUrl;
    }
}

