/*
 * Decompiled with CFR 0.152.
 */
package step.localrunner;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import step.artefacts.Echo;
import step.artefacts.FunctionGroup;
import step.artefacts.Script;
import step.artefacts.Sequence;
import step.artefacts.reports.EchoReportNode;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.dynamicbeans.DynamicValue;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.PlanRunnerResult;
import step.localrunner.LocalPlanRunner;
import step.localrunner.LocalRunnerTestLibrary;
import step.planbuilder.BaseArtefacts;
import step.planbuilder.FunctionArtefacts;

public class LocalPlanRunnerTest {
    protected LocalPlanRunner runner;

    @Before
    public void init() {
        this.runner = new LocalPlanRunner(new Class[]{LocalRunnerTestLibrary.class});
    }

    @Test
    public void testProperties() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("prop1", "MyProp1");
        Echo echo = new Echo();
        echo.setText(new DynamicValue("prop1", ""));
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new Sequence()).add((AbstractArtefact)echo).endBlock().build();
        this.runner = new LocalPlanRunner(properties, new Class[]{LocalRunnerTestLibrary.class});
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> {
            if (node instanceof EchoReportNode) {
                junit.framework.Assert.assertEquals((String)"MyProp1", (String)((EchoReportNode)node).getEcho());
            }
        });
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }

    @Test
    public void testProperties2() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("prop1", "MyProp1");
        Echo echo = new Echo();
        echo.setText(new DynamicValue("prop1", ""));
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new Sequence()).add((AbstractArtefact)echo).endBlock().build();
        this.runner = new LocalPlanRunner(properties, new Class[]{LocalRunnerTestLibrary.class});
        PlanRunnerResult result = this.runner.run(plan, properties);
        result.visitReportNodes(node -> {
            if (node instanceof EchoReportNode) {
                junit.framework.Assert.assertEquals((String)"MyProp1", (String)((EchoReportNode)node).getEcho());
            }
        });
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }

    @Test
    public void testSession() throws IOException {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)new Sequence()).startBlock((AbstractArtefact)new FunctionGroup()).add((AbstractArtefact)FunctionArtefacts.keyword((String)"writeSessionValue", (String)"{\"key\":\"myKey\", \"value\":\"myValue\"}")).add((AbstractArtefact)FunctionArtefacts.keyword((String)"assertSessionValue", (String)"{\"key\":\"myKey\", \"value\":\"myValue\"}")).endBlock().startBlock((AbstractArtefact)new FunctionGroup()).add((AbstractArtefact)FunctionArtefacts.keyword((String)"assertSessionValue", (String)"{\"key\":\"myKey\", \"value\":\"\"}")).endBlock().endBlock().build();
        StringWriter tree = new StringWriter();
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus())).printTree((Writer)tree);
        junit.framework.Assert.assertEquals((String)"Sequence:PASSED:\n Session:PASSED:\n  writeSessionValue:PASSED:\n  assertSessionValue:PASSED:\n Session:PASSED:\n  assertSessionValue:PASSED:\n", (String)tree.toString());
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }

    @Test
    public void testError() throws IOException {
        Script script = new Script();
        script.setScript("throw new Exception()");
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)BaseArtefacts.sequence()).add((AbstractArtefact)script).endBlock().build();
        StringWriter tree = new StringWriter();
        PlanRunnerResult result = this.runner.run(plan);
        result.printTree((Writer)tree);
        junit.framework.Assert.assertEquals((String)"Sequence:TECHNICAL_ERROR:\n Script:TECHNICAL_ERROR:Error while running groovy expression: 'throw new Exception()'\n", (String)tree.toString());
        Assert.assertEquals((Object)ReportNodeStatus.TECHNICAL_ERROR, (Object)result.getResult());
    }

    @Test
    public void testFor() throws IOException {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)BaseArtefacts.for_((int)1, (int)10)).add((AbstractArtefact)FunctionArtefacts.keyword((String)"keyword1")).add((AbstractArtefact)FunctionArtefacts.keyword((String)"keyword1")).endBlock().build();
        String expectedTree = "For:PASSED:\n Iteration 1:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 2:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 3:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 4:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 5:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 6:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 7:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 8:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 9:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n Iteration 10:PASSED:\n  keyword1:PASSED:\n  keyword1:PASSED:\n";
        StringWriter tree = new StringWriter();
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus())).printTree((Writer)tree);
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
        junit.framework.Assert.assertEquals((String)expectedTree, (String)tree.toString());
    }

    @Test
    public void testChain() {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)BaseArtefacts.for_((int)1, (int)10)).add((AbstractArtefact)FunctionArtefacts.keyword((String)"keyword1")).add((AbstractArtefact)FunctionArtefacts.keywordWithDynamicInput((String)"keyword2", (String)"/{\"Param1\":\"${previous.Result1}\"}/.toString()")).endBlock().build();
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus()));
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }

    @Test
    public void testKeywordWithKeyValues() {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)BaseArtefacts.for_((int)1, (int)10)).add((AbstractArtefact)FunctionArtefacts.keywordWithKeyValues((String)"keyword2", (String[])new String[]{"Param1", "value1"})).endBlock().build();
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node.getStatus()));
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }

    public void testKeywordWithDynamicKeyValues() {
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)BaseArtefacts.for_((int)1, (int)10)).add((AbstractArtefact)FunctionArtefacts.keywordWithDynamicKeyValues((String)"keyword1", (String[])new String[]{"Param1", "'value1'"})).add((AbstractArtefact)FunctionArtefacts.keywordWithDynamicKeyValues((String)"keyword2", (String[])new String[]{"Param1", "previous.Param1"})).endBlock().build();
        PlanRunnerResult result = this.runner.run(plan);
        result.visitReportNodes(node -> Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)node));
        Assert.assertEquals((Object)ReportNodeStatus.PASSED, (Object)result.getResult());
    }
}

