/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.jpa;

import ch.hortis.sonar.jpa.DerbyWithDecimalDialect;
import ch.hortis.sonar.jpa.MySqlWithDecimalDialect;
import ch.hortis.sonar.jpa.OracleWithDecimalDialect;
import ch.hortis.sonar.model.JdbcData;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAUtil {
    private static Map<Integer, EntityManagerFactory> factories = new HashMap<Integer, EntityManagerFactory>();

    protected static void reset() {
        for (EntityManagerFactory factory : factories.values()) {
            factory.close();
        }
        factories.clear();
    }

    protected static synchronized EntityManagerFactory getEntityManagerFactory(JdbcData jdbcData, Map<String, String> configuration) {
        Integer key = jdbcData.hashCode();
        EntityManagerFactory factory = factories.get(key);
        if (factory != null) {
            return factory;
        }
        Properties props = new Properties();
        if (jdbcData.getDatasource() == null) {
            props.put("hibernate.connection.url", jdbcData.getUrl());
            props.put("hibernate.connection.driver_class", jdbcData.getDriverClassName());
            props.put("hibernate.connection.username", jdbcData.getUsername());
            props.put("hibernate.connection.password", jdbcData.getPassword());
            props.put("hibernate.dialect", JPAUtil.getHibernateDialect(jdbcData.getUrl()));
        } else {
            props.put("hibernate.connection.datasource", jdbcData.getDatasource());
            props.put("hibernate.dialect", JPAUtil.getHibernateDialect(jdbcData.getDsDialect()));
        }
        String stats = System.getProperty("sonar.db.statistics");
        if ("true".equalsIgnoreCase(stats)) {
            props.put("hibernate.generate_statistics", "true");
        } else {
            props.put("hibernate.generate_statistics", "false");
        }
        if (jdbcData.isCacheEnabled()) {
            props.put("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
            props.put("hibernate.cache.use_second_level_cache", "true");
            props.put("hibernate.cache.use_query_cache", "false");
        } else {
            props.put("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
            props.put("hibernate.cache.use_second_level_cache", "false");
            props.put("hibernate.cache.use_query_cache", "false");
        }
        props.put("hibernate.connection.isolation", Integer.toString(jdbcData.getIsolationLevel()));
        if (configuration != null) {
            props.putAll(configuration);
        }
        factory = Persistence.createEntityManagerFactory((String)"sonar", (Map)props);
        factories.put(key, factory);
        return factory;
    }

    protected static String getHibernateDialect(JdbcData.JDBCDialect dialect) throws PersistenceException {
        if (dialect == JdbcData.JDBCDialect.DB2) {
            return DB2Dialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.DERBY) {
            return DerbyWithDecimalDialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.HSQLDB) {
            return HSQLDialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.MSSQL) {
            return SQLServerDialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.MYSQL) {
            return MySqlWithDecimalDialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.ORACLE) {
            return OracleWithDecimalDialect.class.getName();
        }
        if (dialect == JdbcData.JDBCDialect.POSTGRE) {
            return PostgreSQLDialect.class.getName();
        }
        throw new PersistenceException("Unsupported database for Dialect " + (Object)((Object)dialect));
    }

    protected static String getHibernateDialect(String url) throws PersistenceException {
        if (url.toLowerCase().startsWith("jdbc:db2:")) {
            return DB2Dialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:derby:")) {
            return DerbyWithDecimalDialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:hsqldb:")) {
            return HSQLDialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:microsoft:sqlserver:")) {
            return SQLServerDialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:mysql:")) {
            return MySqlWithDecimalDialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:oracle:")) {
            return OracleWithDecimalDialect.class.getName();
        }
        if (url.toLowerCase().startsWith("jdbc:postgresql:")) {
            return PostgreSQLDialect.class.getName();
        }
        throw new PersistenceException("Unsupported database for URL " + url);
    }

    public static String getJDBCDialect(String url) throws PersistenceException {
        if (url.toLowerCase().startsWith("jdbc:db2:")) {
            return JdbcData.JDBCDialect.DB2.name();
        }
        if (url.toLowerCase().startsWith("jdbc:derby:")) {
            return JdbcData.JDBCDialect.DERBY.name();
        }
        if (url.toLowerCase().startsWith("jdbc:hsqldb:")) {
            return JdbcData.JDBCDialect.HSQLDB.name();
        }
        if (url.toLowerCase().startsWith("jdbc:microsoft:sqlserver:")) {
            return JdbcData.JDBCDialect.MSSQL.name();
        }
        if (url.toLowerCase().startsWith("jdbc:mysql:")) {
            return JdbcData.JDBCDialect.MYSQL.name();
        }
        if (url.toLowerCase().startsWith("jdbc:oracle:")) {
            return JdbcData.JDBCDialect.ORACLE.name();
        }
        if (url.toLowerCase().startsWith("jdbc:postgresql:")) {
            return JdbcData.JDBCDialect.POSTGRE.name();
        }
        throw new PersistenceException("Unsupported database for URL " + url);
    }
}

