/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.jpa;

import ch.hortis.sonar.jpa.JPAUtil;
import ch.hortis.sonar.jpa.PersistenceException;
import ch.hortis.sonar.jpa.WrongDatabaseVersionException;
import ch.hortis.sonar.model.JdbcData;
import ch.hortis.sonar.model.SchemaInfo;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.sql.DataSource;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persistence {
    public static final int MODEL_VERSION = 7;
    protected final JdbcData jdbcData;
    protected final Logger log;
    private EntityManagerFactory factory = null;

    protected Persistence(JdbcData jdbcData) {
        this.jdbcData = jdbcData;
        this.log = LoggerFactory.getLogger((String)this.getClass().getName());
    }

    public static Persistence create(JdbcData jdbcData) throws PersistenceException {
        Persistence persistence = new Persistence(jdbcData);
        persistence.install();
        return persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean databaseExists(JdbcData jdbcData) throws SQLException, WrongDatabaseVersionException {
        Connection jdbcConn;
        if (jdbcData.getDatasource() != null) {
            DataSource ds;
            try {
                InitialContext ctx = new InitialContext();
                ds = (DataSource)ctx.lookup(jdbcData.getDatasource());
            }
            catch (Exception ex) {
                SQLException sqlEx = new SQLException("Error during datasource JNDI lookup");
                sqlEx.initCause(ex);
                throw sqlEx;
            }
            jdbcConn = ds.getConnection();
        } else {
            try {
                Class.forName(jdbcData.getDriverClassName());
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Cannot found sql driver " + jdbcData.getDriverClassName());
            }
            jdbcConn = DriverManager.getConnection(jdbcData.getUrl(), jdbcData.getUsername(), jdbcData.getPassword());
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = jdbcConn.createStatement();
            rs = stmt.executeQuery("SELECT version FROM schema_info");
            if (rs.next()) {
                int version = rs.getInt(1);
                if (version == 7) {
                    boolean bl = true;
                    return bl;
                }
                throw new WrongDatabaseVersionException("Database required model version (7) does not match current version (" + version + ")");
            }
        }
        catch (SQLException ex) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            jdbcConn.close();
        }
        return false;
    }

    private void install() throws PersistenceException {
        try {
            this.factory = JPAUtil.getEntityManagerFactory(this.jdbcData, null);
        }
        catch (javax.persistence.PersistenceException ex) {
            this.log.debug("Persistence exception " + ex.getMessage());
            throw new PersistenceException(ex);
        }
        EntityManager manager = this.factory.createEntityManager();
        try {
            SchemaInfo schemaInfo = (SchemaInfo)manager.find(SchemaInfo.class, (Object)7);
            if (schemaInfo == null) {
                throw new WrongDatabaseVersionException("Database required model version (7) not found");
            }
        }
        catch (NoResultException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        finally {
            manager.close();
        }
    }

    protected final void createDatabase(String creationMode, int version) throws PersistenceException {
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setVersion(version);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("hibernate.hbm2ddl.auto", creationMode);
        try {
            this.factory = JPAUtil.getEntityManagerFactory(this.jdbcData, configuration);
            EntityManager manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            manager.persist((Object)schemaInfo);
            manager.getTransaction().commit();
            manager.close();
            this.log.info("Database created");
        }
        catch (javax.persistence.PersistenceException exception) {
            throw new PersistenceException(exception);
        }
    }

    public void dumpStats(Logger logger) {
        if (this.factory instanceof EntityManagerFactoryImpl) {
            String[] queries;
            String[] entities;
            String[] cacheRegions;
            EntityManagerFactoryImpl hibernateFactory = (EntityManagerFactoryImpl)this.factory;
            Statistics stats = hibernateFactory.getSessionFactory().getStatistics();
            if (!stats.isStatisticsEnabled()) {
                logger.info("DB statistics computation are disabled, enable them using sonar.db.statistics=true system property");
                return;
            }
            double cacheHitCount = stats.getSecondLevelCacheHitCount();
            Date statsDate = new Date(stats.getStartTime());
            logger.info("DB Statistics computed since " + statsDate);
            logger.info("");
            logger.info("Cache hit count:" + cacheHitCount);
            double cacheMissCount = stats.getSecondLevelCacheMissCount();
            logger.info("Cache miss count:" + cacheMissCount);
            double cachePutCount = stats.getSecondLevelCachePutCount();
            logger.info("Cache put count:" + cachePutCount);
            double cacheHitRatio = cacheHitCount / (cacheHitCount + cacheMissCount);
            logger.info("Cache Hit ratio:" + cacheHitRatio);
            logger.info("");
            logger.info("Cache regions statistics :");
            logger.info("");
            for (String region : cacheRegions = stats.getSecondLevelCacheRegionNames()) {
                SecondLevelCacheStatistics cacheStats = stats.getSecondLevelCacheStatistics(region);
                logger.info("Cache region:" + cacheStats.getCategoryName());
                logger.info("Elements in memory:" + cacheStats.getElementCountInMemory());
                logger.info("Hits count:" + cacheStats.getHitCount());
                logger.info("Miss count:" + cacheStats.getMissCount());
                logger.info("Put count:" + cacheStats.getPutCount());
                logger.info("");
            }
            logger.info("Entites statistics :");
            logger.info("");
            for (String entity : entities = stats.getEntityNames()) {
                EntityStatistics stat = stats.getEntityStatistics(entity);
                logger.info("Entity name:" + stat.getCategoryName());
                logger.info("Entity delete count:" + stat.getDeleteCount());
                logger.info("Entity fetch count:" + stat.getFetchCount());
                logger.info("Entity insert count:" + stat.getInsertCount());
                logger.info("Entity load count:" + stat.getLoadCount());
                logger.info("Entity update count:" + stat.getUpdateCount());
                logger.info("");
            }
            logger.info("Queries statistics :\n");
            logger.info("Queries execution count :" + stats.getQueryExecutionCount());
            logger.info("Queries max time :" + stats.getQueryExecutionMaxTime());
            logger.info("Queries max time sql:" + stats.getQueryExecutionMaxTimeQueryString());
            logger.info("");
            for (String query : queries = stats.getQueries()) {
                QueryStatistics stat = stats.getQueryStatistics(query);
                logger.info("Query name:" + stat.getCategoryName());
                logger.info("Query cache hit count:" + stat.getCacheHitCount());
                logger.info("Query cache miss count:" + stat.getCacheMissCount());
                logger.info("Query cache put count:" + stat.getCachePutCount());
                logger.info("Query exec count:" + stat.getExecutionCount());
                logger.info("Query avg time:" + stat.getExecutionAvgTime());
                logger.info("Query max time:" + stat.getExecutionMaxTime());
                logger.info("Query min time:" + stat.getExecutionMinTime());
                logger.info("Query row count:" + stat.getExecutionRowCount());
                logger.info("");
            }
            stats.clear();
        }
    }

    public EntityManager getNewEntityManager() {
        return this.factory.createEntityManager();
    }

    public void close() {
        if (this.factory.isOpen()) {
            this.factory.close();
        }
    }
}

