/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileSource;
import ch.hortis.sonar.model.Snapshot;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Entity
@Table(name="files")
public class File
implements Collectable {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="FILES_SEQ", sequenceName="FILES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="FILES_SEQ")
    private Integer id;
    @Column(name="filename", updatable=false, nullable=false, length=255)
    private String filename;
    @Column(name="namespace", updatable=false, nullable=true, length=500)
    private String namespace;
    @Column(name="path", updatable=false, nullable=true, length=500)
    private String path;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_id")
    private Snapshot snapshot;
    @OneToOne(mappedBy="file", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public FileSource fileSource;

    public File(String filename, String namespace, String path) {
        this.setFilename(filename);
        this.namespace = namespace;
        this.path = path;
    }

    public File(int id, String filename, String namespace, String path) {
        this(filename, namespace, path);
        this.setId(id);
    }

    public File() {
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        String prefix = StringUtils.substringBeforeLast((String)filename, (String)".");
        String suffix = StringUtils.substringAfterLast((String)filename, (String)".");
        this.filename = prefix + "." + suffix.toLowerCase();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public FileSource getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(FileSource fileSource) {
        this.fileSource = fileSource;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        File other = (File)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return this.id + ":".concat(this.namespace).concat(":").concat(this.filename);
    }
}

