/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.File;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.MetricMeasure;
import ch.hortis.sonar.model.Parameter;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.model.WithFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="file_measures")
public class FileMeasure
extends MetricMeasure
implements Serializable,
WithFile,
Collectable {
    private static final long serialVersionUID = -8547266020380372485L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="FILE_MEASURES_SEQ", sequenceName="FILE_MEASURES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="FILE_MEASURES_SEQ")
    private Integer id;
    @ManyToOne(optional=false, fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="file_id", updatable=false, nullable=false)
    private File file;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinTable(name="file_measures_parameters", joinColumns={@JoinColumn(name="file_measure_id")}, inverseJoinColumns={@JoinColumn(name="parameter_id")})
    private List<Parameter> parameters;

    public FileMeasure() {
    }

    public FileMeasure(Snapshot snapshot, Metric metric, Double value, File file) {
        this.snapshot = snapshot;
        this.metric = metric;
        this.value = value;
        this.file = file;
        this.parameters = new ArrayList<Parameter>();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, Double value) {
        this.addParameter(key, value, null);
    }

    public void addParameter(String key, Double value, Double value2) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(new Parameter(key, value, value2));
    }

    public Parameter getParameter(String key) {
        for (Parameter param : this.getParameters()) {
            if (!param.getKey().equals(key)) continue;
            return param;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileMeasure)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileMeasure other = (FileMeasure)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("value", (Object)this.value).append("metric", (Object)this.metric).append("file", (Object)this.file).toString();
    }
}

